/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.InstanceState;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterGatewayInstanceResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, DeregisterGatewayInstanceResponse> {
    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayInstanceArn").getter(DeregisterGatewayInstanceResponse.getter(DeregisterGatewayInstanceResponse::gatewayInstanceArn)).setter(DeregisterGatewayInstanceResponse.setter(Builder::gatewayInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build()}).build();
    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceState").getter(DeregisterGatewayInstanceResponse.getter(DeregisterGatewayInstanceResponse::instanceStateAsString)).setter(DeregisterGatewayInstanceResponse.setter(Builder::instanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_INSTANCE_ARN_FIELD, INSTANCE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
            this.put("instanceState", INSTANCE_STATE_FIELD);
        }
    });
    private final String gatewayInstanceArn;
    private final String instanceState;

    private DeregisterGatewayInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
        this.instanceState = builder.instanceState;
    }

    public final String gatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    public final InstanceState instanceState() {
        return InstanceState.fromValue(this.instanceState);
    }

    public final String instanceStateAsString() {
        return this.instanceState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterGatewayInstanceResponse)) {
            return false;
        }
        DeregisterGatewayInstanceResponse other = (DeregisterGatewayInstanceResponse)((Object)obj);
        return Objects.equals(this.gatewayInstanceArn(), other.gatewayInstanceArn()) && Objects.equals(this.instanceStateAsString(), other.instanceStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterGatewayInstanceResponse").add("GatewayInstanceArn", (Object)this.gatewayInstanceArn()).add("InstanceState", (Object)this.instanceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayInstanceArn()));
            }
            case "InstanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterGatewayInstanceResponse, T> g) {
        return obj -> g.apply((DeregisterGatewayInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String gatewayInstanceArn;
        private String instanceState;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterGatewayInstanceResponse model) {
            super(model);
            this.gatewayInstanceArn(model.gatewayInstanceArn);
            this.instanceState(model.instanceState);
        }

        public final String getGatewayInstanceArn() {
            return this.gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        public final String getInstanceState() {
            return this.instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        @Override
        public DeregisterGatewayInstanceResponse build() {
            return new DeregisterGatewayInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterGatewayInstanceResponse> {
        public Builder gatewayInstanceArn(String var1);

        public Builder instanceState(String var1);

        public Builder instanceState(InstanceState var1);
    }
}

