/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MessageDetail;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMessageDetailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThumbnailDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThumbnailDetails> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(ThumbnailDetails.getter(ThumbnailDetails::flowArn)).setter(ThumbnailDetails.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> THUMBNAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Thumbnail").getter(ThumbnailDetails.getter(ThumbnailDetails::thumbnail)).setter(ThumbnailDetails.setter(Builder::thumbnail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnail").build()}).build();
    private static final SdkField<List<MessageDetail>> THUMBNAIL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThumbnailMessages").getter(ThumbnailDetails.getter(ThumbnailDetails::thumbnailMessages)).setter(ThumbnailDetails.setter(Builder::thumbnailMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timecode").getter(ThumbnailDetails.getter(ThumbnailDetails::timecode)).setter(ThumbnailDetails.setter(Builder::timecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(ThumbnailDetails.getter(ThumbnailDetails::timestamp)).setter(ThumbnailDetails.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, THUMBNAIL_FIELD, THUMBNAIL_MESSAGES_FIELD, TIMECODE_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String flowArn;
    private final String thumbnail;
    private final List<MessageDetail> thumbnailMessages;
    private final String timecode;
    private final Instant timestamp;

    private ThumbnailDetails(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.thumbnail = builder.thumbnail;
        this.thumbnailMessages = builder.thumbnailMessages;
        this.timecode = builder.timecode;
        this.timestamp = builder.timestamp;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String thumbnail() {
        return this.thumbnail;
    }

    public final boolean hasThumbnailMessages() {
        return this.thumbnailMessages != null && !(this.thumbnailMessages instanceof SdkAutoConstructList);
    }

    public final List<MessageDetail> thumbnailMessages() {
        return this.thumbnailMessages;
    }

    public final String timecode() {
        return this.timecode;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThumbnailMessages() ? this.thumbnailMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timecode());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailDetails)) {
            return false;
        }
        ThumbnailDetails other = (ThumbnailDetails)obj;
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.thumbnail(), other.thumbnail()) && this.hasThumbnailMessages() == other.hasThumbnailMessages() && Objects.equals(this.thumbnailMessages(), other.thumbnailMessages()) && Objects.equals(this.timecode(), other.timecode()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ThumbnailDetails").add("FlowArn", (Object)this.flowArn()).add("Thumbnail", (Object)this.thumbnail()).add("ThumbnailMessages", this.hasThumbnailMessages() ? this.thumbnailMessages() : null).add("Timecode", (Object)this.timecode()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "Thumbnail": {
                return Optional.ofNullable(clazz.cast(this.thumbnail()));
            }
            case "ThumbnailMessages": {
                return Optional.ofNullable(clazz.cast(this.thumbnailMessages()));
            }
            case "Timecode": {
                return Optional.ofNullable(clazz.cast(this.timecode()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailDetails, T> g) {
        return obj -> g.apply((ThumbnailDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowArn;
        private String thumbnail;
        private List<MessageDetail> thumbnailMessages = DefaultSdkAutoConstructList.getInstance();
        private String timecode;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailDetails model) {
            this.flowArn(model.flowArn);
            this.thumbnail(model.thumbnail);
            this.thumbnailMessages(model.thumbnailMessages);
            this.timecode(model.timecode);
            this.timestamp(model.timestamp);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getThumbnail() {
            return this.thumbnail;
        }

        public final void setThumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
        }

        @Override
        public final Builder thumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public final List<MessageDetail.Builder> getThumbnailMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.thumbnailMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnailMessages(Collection<MessageDetail.BuilderImpl> thumbnailMessages) {
            this.thumbnailMessages = ___listOfMessageDetailCopier.copyFromBuilder(thumbnailMessages);
        }

        @Override
        public final Builder thumbnailMessages(Collection<MessageDetail> thumbnailMessages) {
            this.thumbnailMessages = ___listOfMessageDetailCopier.copy(thumbnailMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(MessageDetail ... thumbnailMessages) {
            this.thumbnailMessages(Arrays.asList(thumbnailMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(Consumer<MessageDetail.Builder> ... thumbnailMessages) {
            this.thumbnailMessages(Stream.of(thumbnailMessages).map(c -> (MessageDetail)((MessageDetail.Builder)MessageDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimecode() {
            return this.timecode;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ThumbnailDetails build() {
            return new ThumbnailDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThumbnailDetails> {
        public Builder flowArn(String var1);

        public Builder thumbnail(String var1);

        public Builder thumbnailMessages(Collection<MessageDetail> var1);

        public Builder thumbnailMessages(MessageDetail ... var1);

        public Builder thumbnailMessages(Consumer<MessageDetail.Builder> ... var1);

        public Builder timecode(String var1);

        public Builder timestamp(Instant var1);
    }
}

