/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedEntitlement;

public class ListEntitlementsPublisher
implements SdkPublisher<ListEntitlementsResponse> {
    private final MediaConnectAsyncClient client;
    private final ListEntitlementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntitlementsPublisher(MediaConnectAsyncClient client, ListEntitlementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntitlementsPublisher(MediaConnectAsyncClient client, ListEntitlementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntitlementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntitlementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedEntitlement> entitlements() {
        Function<ListEntitlementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entitlements() != null) {
                return response.entitlements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntitlementsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEntitlementsResponseFetcher
    implements AsyncPageFetcher<ListEntitlementsResponse> {
        private ListEntitlementsResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitlementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntitlementsResponse> nextPage(ListEntitlementsResponse previousPage) {
            if (previousPage == null) {
                return ListEntitlementsPublisher.this.client.listEntitlements(ListEntitlementsPublisher.this.firstRequest);
            }
            return ListEntitlementsPublisher.this.client.listEntitlements((ListEntitlementsRequest)((Object)ListEntitlementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

