/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedGatewayInstance;

public class ListGatewayInstancesPublisher
implements SdkPublisher<ListGatewayInstancesResponse> {
    private final MediaConnectAsyncClient client;
    private final ListGatewayInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGatewayInstancesPublisher(MediaConnectAsyncClient client, ListGatewayInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGatewayInstancesPublisher(MediaConnectAsyncClient client, ListGatewayInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGatewayInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGatewayInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedGatewayInstance> instances() {
        Function<ListGatewayInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGatewayInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGatewayInstancesResponseFetcher
    implements AsyncPageFetcher<ListGatewayInstancesResponse> {
        private ListGatewayInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGatewayInstancesResponse> nextPage(ListGatewayInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayInstancesPublisher.this.client.listGatewayInstances(ListGatewayInstancesPublisher.this.firstRequest);
            }
            return ListGatewayInstancesPublisher.this.client.listGatewayInstances((ListGatewayInstancesRequest)((Object)ListGatewayInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

