/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceAttachment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetGatewayBridgeSourceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SetGatewayBridgeSourceRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(SetGatewayBridgeSourceRequest.getter(SetGatewayBridgeSourceRequest::bridgeArn)).setter(SetGatewayBridgeSourceRequest.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<VpcInterfaceAttachment> VPC_INTERFACE_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcInterfaceAttachment").getter(SetGatewayBridgeSourceRequest.getter(SetGatewayBridgeSourceRequest::vpcInterfaceAttachment)).setter(SetGatewayBridgeSourceRequest.setter(Builder::vpcInterfaceAttachment)).constructor(VpcInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAttachment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, VPC_INTERFACE_ATTACHMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bridgeArn;
    private final VpcInterfaceAttachment vpcInterfaceAttachment;

    private SetGatewayBridgeSourceRequest(BuilderImpl builder) {
        this.bridgeArn = builder.bridgeArn;
        this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final VpcInterfaceAttachment vpcInterfaceAttachment() {
        return this.vpcInterfaceAttachment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceAttachment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetGatewayBridgeSourceRequest)) {
            return false;
        }
        SetGatewayBridgeSourceRequest other = (SetGatewayBridgeSourceRequest)obj;
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.vpcInterfaceAttachment(), other.vpcInterfaceAttachment());
    }

    public final String toString() {
        return ToString.builder((String)"SetGatewayBridgeSourceRequest").add("BridgeArn", (Object)this.bridgeArn()).add("VpcInterfaceAttachment", (Object)this.vpcInterfaceAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "VpcInterfaceAttachment": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceAttachment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetGatewayBridgeSourceRequest, T> g) {
        return obj -> g.apply((SetGatewayBridgeSourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bridgeArn;
        private VpcInterfaceAttachment vpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(SetGatewayBridgeSourceRequest model) {
            this.bridgeArn(model.bridgeArn);
            this.vpcInterfaceAttachment(model.vpcInterfaceAttachment);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getVpcInterfaceAttachment() {
            return this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment != null ? vpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        public SetGatewayBridgeSourceRequest build() {
            return new SetGatewayBridgeSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SetGatewayBridgeSourceRequest> {
        public Builder bridgeArn(String var1);

        public Builder vpcInterfaceAttachment(VpcInterfaceAttachment var1);

        default public Builder vpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> vpcInterfaceAttachment) {
            return this.vpcInterfaceAttachment((VpcInterfaceAttachment)((VpcInterfaceAttachment.Builder)VpcInterfaceAttachment.builder().applyMutation(vpcInterfaceAttachment)).build());
        }
    }
}

