/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedBridge;

public class ListBridgesPublisher
implements SdkPublisher<ListBridgesResponse> {
    private final MediaConnectAsyncClient client;
    private final ListBridgesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBridgesPublisher(MediaConnectAsyncClient client, ListBridgesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBridgesPublisher(MediaConnectAsyncClient client, ListBridgesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBridgesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBridgesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedBridge> bridges() {
        Function<ListBridgesResponse, Iterator> getIterator = response -> {
            if (response != null && response.bridges() != null) {
                return response.bridges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBridgesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBridgesResponseFetcher
    implements AsyncPageFetcher<ListBridgesResponse> {
        private ListBridgesResponseFetcher() {
        }

        public boolean hasNextPage(ListBridgesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBridgesResponse> nextPage(ListBridgesResponse previousPage) {
            if (previousPage == null) {
                return ListBridgesPublisher.this.client.listBridges(ListBridgesPublisher.this.firstRequest);
            }
            return ListBridgesPublisher.this.client.listBridges((ListBridgesRequest)((Object)ListBridgesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

