/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveFlowOutputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, RemoveFlowOutputResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(RemoveFlowOutputResponse.getter(RemoveFlowOutputResponse::flowArn)).setter(RemoveFlowOutputResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputArn").getter(RemoveFlowOutputResponse.getter(RemoveFlowOutputResponse::outputArn)).setter(RemoveFlowOutputResponse.setter(Builder::outputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, OUTPUT_ARN_FIELD));
    private final String flowArn;
    private final String outputArn;

    private RemoveFlowOutputResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.outputArn = builder.outputArn;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final String outputArn() {
        return this.outputArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveFlowOutputResponse)) {
            return false;
        }
        RemoveFlowOutputResponse other = (RemoveFlowOutputResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.outputArn(), other.outputArn());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveFlowOutputResponse").add("FlowArn", (Object)this.flowArn()).add("OutputArn", (Object)this.outputArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "OutputArn": {
                return Optional.ofNullable(clazz.cast(this.outputArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveFlowOutputResponse, T> g) {
        return obj -> g.apply((RemoveFlowOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private String outputArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveFlowOutputResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.outputArn(model.outputArn);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getOutputArn() {
            return this.outputArn;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        @Override
        public RemoveFlowOutputResponse build() {
            return new RemoveFlowOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveFlowOutputResponse> {
        public Builder flowArn(String var1);

        public Builder outputArn(String var1);
    }
}

