/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.AddMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.FailoverConfig;
import software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.SetSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAddMediaStreamRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAddOutputRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfGrantEntitlementRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfSetSourceRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfVpcInterfaceRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, CreateFlowRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateFlowRequest.getter(CreateFlowRequest::availabilityZone)).setter(CreateFlowRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<List<GrantEntitlementRequest>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entitlements").getter(CreateFlowRequest.getter(CreateFlowRequest::entitlements)).setter(CreateFlowRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrantEntitlementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddMediaStreamRequest>> MEDIA_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreams").getter(CreateFlowRequest.getter(CreateFlowRequest::mediaStreams)).setter(CreateFlowRequest.setter(Builder::mediaStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddMediaStreamRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateFlowRequest.getter(CreateFlowRequest::name)).setter(CreateFlowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<AddOutputRequest>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(CreateFlowRequest.getter(CreateFlowRequest::outputs)).setter(CreateFlowRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOutputRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SetSourceRequest> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(CreateFlowRequest.getter(CreateFlowRequest::source)).setter(CreateFlowRequest.setter(Builder::source)).constructor(SetSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<FailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFailoverConfig").getter(CreateFlowRequest.getter(CreateFlowRequest::sourceFailoverConfig)).setter(CreateFlowRequest.setter(Builder::sourceFailoverConfig)).constructor(FailoverConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build()}).build();
    private static final SdkField<List<SetSourceRequest>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(CreateFlowRequest.getter(CreateFlowRequest::sources)).setter(CreateFlowRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SetSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VpcInterfaceRequest>> VPC_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcInterfaces").getter(CreateFlowRequest.getter(CreateFlowRequest::vpcInterfaces)).setter(CreateFlowRequest.setter(Builder::vpcInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcInterfaceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, ENTITLEMENTS_FIELD, MEDIA_STREAMS_FIELD, NAME_FIELD, OUTPUTS_FIELD, SOURCE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD, SOURCES_FIELD, VPC_INTERFACES_FIELD));
    private final String availabilityZone;
    private final List<GrantEntitlementRequest> entitlements;
    private final List<AddMediaStreamRequest> mediaStreams;
    private final String name;
    private final List<AddOutputRequest> outputs;
    private final SetSourceRequest source;
    private final FailoverConfig sourceFailoverConfig;
    private final List<SetSourceRequest> sources;
    private final List<VpcInterfaceRequest> vpcInterfaces;

    private CreateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.entitlements = builder.entitlements;
        this.mediaStreams = builder.mediaStreams;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
        this.sources = builder.sources;
        this.vpcInterfaces = builder.vpcInterfaces;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public final List<GrantEntitlementRequest> entitlements() {
        return this.entitlements;
    }

    public final boolean hasMediaStreams() {
        return this.mediaStreams != null && !(this.mediaStreams instanceof SdkAutoConstructList);
    }

    public final List<AddMediaStreamRequest> mediaStreams() {
        return this.mediaStreams;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<AddOutputRequest> outputs() {
        return this.outputs;
    }

    public final SetSourceRequest source() {
        return this.source;
    }

    public final FailoverConfig sourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<SetSourceRequest> sources() {
        return this.sources;
    }

    public final boolean hasVpcInterfaces() {
        return this.vpcInterfaces != null && !(this.vpcInterfaces instanceof SdkAutoConstructList);
    }

    public final List<VpcInterfaceRequest> vpcInterfaces() {
        return this.vpcInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlements() ? this.entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreams() ? this.mediaStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFailoverConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcInterfaces() ? this.vpcInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowRequest)) {
            return false;
        }
        CreateFlowRequest other = (CreateFlowRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasEntitlements() == other.hasEntitlements() && Objects.equals(this.entitlements(), other.entitlements()) && this.hasMediaStreams() == other.hasMediaStreams() && Objects.equals(this.mediaStreams(), other.mediaStreams()) && Objects.equals(this.name(), other.name()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceFailoverConfig(), other.sourceFailoverConfig()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasVpcInterfaces() == other.hasVpcInterfaces() && Objects.equals(this.vpcInterfaces(), other.vpcInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFlowRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Entitlements", this.hasEntitlements() ? this.entitlements() : null).add("MediaStreams", this.hasMediaStreams() ? this.mediaStreams() : null).add("Name", (Object)this.name()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Source", (Object)this.source()).add("SourceFailoverConfig", (Object)this.sourceFailoverConfig()).add("Sources", this.hasSources() ? this.sources() : null).add("VpcInterfaces", this.hasVpcInterfaces() ? this.vpcInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "MediaStreams": {
                return Optional.ofNullable(clazz.cast(this.mediaStreams()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourceFailoverConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFailoverConfig()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "VpcInterfaces": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowRequest, T> g) {
        return obj -> g.apply((CreateFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<GrantEntitlementRequest> entitlements = DefaultSdkAutoConstructList.getInstance();
        private List<AddMediaStreamRequest> mediaStreams = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<AddOutputRequest> outputs = DefaultSdkAutoConstructList.getInstance();
        private SetSourceRequest source;
        private FailoverConfig sourceFailoverConfig;
        private List<SetSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();
        private List<VpcInterfaceRequest> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.entitlements(model.entitlements);
            this.mediaStreams(model.mediaStreams);
            this.name(model.name);
            this.outputs(model.outputs);
            this.source(model.source);
            this.sourceFailoverConfig(model.sourceFailoverConfig);
            this.sources(model.sources);
            this.vpcInterfaces(model.vpcInterfaces);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<GrantEntitlementRequest.Builder> getEntitlements() {
            List<GrantEntitlementRequest.Builder> result = ___listOfGrantEntitlementRequestCopier.copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<GrantEntitlementRequest.BuilderImpl> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copyFromBuilder(entitlements);
        }

        @Override
        @Transient
        public final Builder entitlements(Collection<GrantEntitlementRequest> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copy(entitlements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlements(GrantEntitlementRequest ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitlements(Consumer<GrantEntitlementRequest.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (GrantEntitlementRequest)((GrantEntitlementRequest.Builder)GrantEntitlementRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddMediaStreamRequest.Builder> getMediaStreams() {
            List<AddMediaStreamRequest.Builder> result = ___listOfAddMediaStreamRequestCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreams(Collection<AddMediaStreamRequest.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfAddMediaStreamRequestCopier.copyFromBuilder(mediaStreams);
        }

        @Override
        @Transient
        public final Builder mediaStreams(Collection<AddMediaStreamRequest> mediaStreams) {
            this.mediaStreams = ___listOfAddMediaStreamRequestCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreams(AddMediaStreamRequest ... mediaStreams) {
            this.mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreams(Consumer<AddMediaStreamRequest.Builder> ... mediaStreams) {
            this.mediaStreams(Stream.of(mediaStreams).map(c -> (AddMediaStreamRequest)((AddMediaStreamRequest.Builder)AddMediaStreamRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AddOutputRequest.Builder> getOutputs() {
            List<AddOutputRequest.Builder> result = ___listOfAddOutputRequestCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<AddOutputRequest.BuilderImpl> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<AddOutputRequest> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(AddOutputRequest ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<AddOutputRequest.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (AddOutputRequest)((AddOutputRequest.Builder)AddOutputRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SetSourceRequest.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(SetSourceRequest.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(SetSourceRequest source) {
            this.source = source;
            return this;
        }

        public final FailoverConfig.Builder getSourceFailoverConfig() {
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(FailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        public final List<SetSourceRequest.Builder> getSources() {
            List<SetSourceRequest.Builder> result = ___listOfSetSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SetSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfSetSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        @Transient
        public final Builder sources(Collection<SetSourceRequest> sources) {
            this.sources = ___listOfSetSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sources(SetSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sources(Consumer<SetSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (SetSourceRequest)((SetSourceRequest.Builder)SetSourceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcInterfaceRequest.Builder> getVpcInterfaces() {
            List<VpcInterfaceRequest.Builder> result = ___listOfVpcInterfaceRequestCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcInterfaces(Collection<VpcInterfaceRequest.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceRequestCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        @Transient
        public final Builder vpcInterfaces(Collection<VpcInterfaceRequest> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceRequestCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterfaceRequest ... vpcInterfaces) {
            this.vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterfaceRequest.Builder> ... vpcInterfaces) {
            this.vpcInterfaces(Stream.of(vpcInterfaces).map(c -> (VpcInterfaceRequest)((VpcInterfaceRequest.Builder)VpcInterfaceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowRequest build() {
            return new CreateFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowRequest> {
        public Builder availabilityZone(String var1);

        public Builder entitlements(Collection<GrantEntitlementRequest> var1);

        public Builder entitlements(GrantEntitlementRequest ... var1);

        public Builder entitlements(Consumer<GrantEntitlementRequest.Builder> ... var1);

        public Builder mediaStreams(Collection<AddMediaStreamRequest> var1);

        public Builder mediaStreams(AddMediaStreamRequest ... var1);

        public Builder mediaStreams(Consumer<AddMediaStreamRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder outputs(Collection<AddOutputRequest> var1);

        public Builder outputs(AddOutputRequest ... var1);

        public Builder outputs(Consumer<AddOutputRequest.Builder> ... var1);

        public Builder source(SetSourceRequest var1);

        default public Builder source(Consumer<SetSourceRequest.Builder> source) {
            return this.source((SetSourceRequest)((SetSourceRequest.Builder)SetSourceRequest.builder().applyMutation(source)).build());
        }

        public Builder sourceFailoverConfig(FailoverConfig var1);

        default public Builder sourceFailoverConfig(Consumer<FailoverConfig.Builder> sourceFailoverConfig) {
            return this.sourceFailoverConfig((FailoverConfig)((FailoverConfig.Builder)FailoverConfig.builder().applyMutation(sourceFailoverConfig)).build());
        }

        public Builder sources(Collection<SetSourceRequest> var1);

        public Builder sources(SetSourceRequest ... var1);

        public Builder sources(Consumer<SetSourceRequest.Builder> ... var1);

        public Builder vpcInterfaces(Collection<VpcInterfaceRequest> var1);

        public Builder vpcInterfaces(VpcInterfaceRequest ... var1);

        public Builder vpcInterfaces(Consumer<VpcInterfaceRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

