/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Tcs {
    SDR("SDR"),
    PQ("PQ"),
    HLG("HLG"),
    LINEAR("LINEAR"),
    BT2100_LINPQ("BT2100LINPQ"),
    BT2100_LINHLG("BT2100LINHLG"),
    ST2065_1("ST2065-1"),
    ST428_1("ST428-1"),
    DENSITY("DENSITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Tcs> VALUE_MAP;
    private final String value;

    private Tcs(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Tcs fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Tcs> knownValues() {
        EnumSet<Tcs> knownValues = EnumSet.allOf(Tcs.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Tcs.class, Tcs::toString);
    }
}

