/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfigurationRequest;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.services.mediaconnect.model.UpdateEncryption;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMediaStreamSourceConfigurationRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowSourceRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateFlowSourceRequest> {
    private static final SdkField<UpdateEncryption> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Decryption").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::decryption)).setter(UpdateFlowSourceRequest.setter(Builder::decryption)).constructor(UpdateEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::description)).setter(UpdateFlowSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementArn").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::entitlementArn)).setter(UpdateFlowSourceRequest.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::flowArn)).setter(UpdateFlowSourceRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IngestPort").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::ingestPort)).setter(UpdateFlowSourceRequest.setter(Builder::ingestPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::maxBitrate)).setter(UpdateFlowSourceRequest.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLatency").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::maxLatency)).setter(UpdateFlowSourceRequest.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<Integer> MAX_SYNC_BUFFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSyncBuffer").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::maxSyncBuffer)).setter(UpdateFlowSourceRequest.setter(Builder::maxSyncBuffer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSyncBuffer").build()}).build();
    private static final SdkField<List<MediaStreamSourceConfigurationRequest>> MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreamSourceConfigurations").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::mediaStreamSourceConfigurations)).setter(UpdateFlowSourceRequest.setter(Builder::mediaStreamSourceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamSourceConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStreamSourceConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinLatency").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::minLatency)).setter(UpdateFlowSourceRequest.setter(Builder::minLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::protocolAsString)).setter(UpdateFlowSourceRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SenderControlPort").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::senderControlPort)).setter(UpdateFlowSourceRequest.setter(Builder::senderControlPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()}).build();
    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderIpAddress").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::senderIpAddress)).setter(UpdateFlowSourceRequest.setter(Builder::senderIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIpAddress").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::sourceArn)).setter(UpdateFlowSourceRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceArn").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::streamId)).setter(UpdateFlowSourceRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcInterfaceName").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::vpcInterfaceName)).setter(UpdateFlowSourceRequest.setter(Builder::vpcInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()}).build();
    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhitelistCidr").getter(UpdateFlowSourceRequest.getter(UpdateFlowSourceRequest::whitelistCidr)).setter(UpdateFlowSourceRequest.setter(Builder::whitelistCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD, DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, FLOW_ARN_FIELD, INGEST_PORT_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, MAX_SYNC_BUFFER_FIELD, MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD, MIN_LATENCY_FIELD, PROTOCOL_FIELD, SENDER_CONTROL_PORT_FIELD, SENDER_IP_ADDRESS_FIELD, SOURCE_ARN_FIELD, STREAM_ID_FIELD, VPC_INTERFACE_NAME_FIELD, WHITELIST_CIDR_FIELD));
    private final UpdateEncryption decryption;
    private final String description;
    private final String entitlementArn;
    private final String flowArn;
    private final Integer ingestPort;
    private final Integer maxBitrate;
    private final Integer maxLatency;
    private final Integer maxSyncBuffer;
    private final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations;
    private final Integer minLatency;
    private final String protocol;
    private final Integer senderControlPort;
    private final String senderIpAddress;
    private final String sourceArn;
    private final String streamId;
    private final String vpcInterfaceName;
    private final String whitelistCidr;

    private UpdateFlowSourceRequest(BuilderImpl builder) {
        super(builder);
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.flowArn = builder.flowArn;
        this.ingestPort = builder.ingestPort;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.maxSyncBuffer = builder.maxSyncBuffer;
        this.mediaStreamSourceConfigurations = builder.mediaStreamSourceConfigurations;
        this.minLatency = builder.minLatency;
        this.protocol = builder.protocol;
        this.senderControlPort = builder.senderControlPort;
        this.senderIpAddress = builder.senderIpAddress;
        this.sourceArn = builder.sourceArn;
        this.streamId = builder.streamId;
        this.vpcInterfaceName = builder.vpcInterfaceName;
        this.whitelistCidr = builder.whitelistCidr;
    }

    public final UpdateEncryption decryption() {
        return this.decryption;
    }

    public final String description() {
        return this.description;
    }

    public final String entitlementArn() {
        return this.entitlementArn;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final Integer ingestPort() {
        return this.ingestPort;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer maxLatency() {
        return this.maxLatency;
    }

    public final Integer maxSyncBuffer() {
        return this.maxSyncBuffer;
    }

    public final boolean hasMediaStreamSourceConfigurations() {
        return this.mediaStreamSourceConfigurations != null && !(this.mediaStreamSourceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations() {
        return this.mediaStreamSourceConfigurations;
    }

    public final Integer minLatency() {
        return this.minLatency;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer senderControlPort() {
        return this.senderControlPort;
    }

    public final String senderIpAddress() {
        return this.senderIpAddress;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String vpcInterfaceName() {
        return this.vpcInterfaceName;
    }

    public final String whitelistCidr() {
        return this.whitelistCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSyncBuffer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreamSourceConfigurations() ? this.mediaStreamSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistCidr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowSourceRequest)) {
            return false;
        }
        UpdateFlowSourceRequest other = (UpdateFlowSourceRequest)((Object)obj);
        return Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.ingestPort(), other.ingestPort()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.maxSyncBuffer(), other.maxSyncBuffer()) && this.hasMediaStreamSourceConfigurations() == other.hasMediaStreamSourceConfigurations() && Objects.equals(this.mediaStreamSourceConfigurations(), other.mediaStreamSourceConfigurations()) && Objects.equals(this.minLatency(), other.minLatency()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.senderControlPort(), other.senderControlPort()) && Objects.equals(this.senderIpAddress(), other.senderIpAddress()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.vpcInterfaceName(), other.vpcInterfaceName()) && Objects.equals(this.whitelistCidr(), other.whitelistCidr());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowSourceRequest").add("Decryption", (Object)this.decryption()).add("Description", (Object)this.description()).add("EntitlementArn", (Object)this.entitlementArn()).add("FlowArn", (Object)this.flowArn()).add("IngestPort", (Object)this.ingestPort()).add("MaxBitrate", (Object)this.maxBitrate()).add("MaxLatency", (Object)this.maxLatency()).add("MaxSyncBuffer", (Object)this.maxSyncBuffer()).add("MediaStreamSourceConfigurations", this.hasMediaStreamSourceConfigurations() ? this.mediaStreamSourceConfigurations() : null).add("MinLatency", (Object)this.minLatency()).add("Protocol", (Object)this.protocolAsString()).add("SenderControlPort", (Object)this.senderControlPort()).add("SenderIpAddress", (Object)this.senderIpAddress()).add("SourceArn", (Object)this.sourceArn()).add("StreamId", (Object)this.streamId()).add("VpcInterfaceName", (Object)this.vpcInterfaceName()).add("WhitelistCidr", (Object)this.whitelistCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "IngestPort": {
                return Optional.ofNullable(clazz.cast(this.ingestPort()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "MaxSyncBuffer": {
                return Optional.ofNullable(clazz.cast(this.maxSyncBuffer()));
            }
            case "MediaStreamSourceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamSourceConfigurations()));
            }
            case "MinLatency": {
                return Optional.ofNullable(clazz.cast(this.minLatency()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "SenderControlPort": {
                return Optional.ofNullable(clazz.cast(this.senderControlPort()));
            }
            case "SenderIpAddress": {
                return Optional.ofNullable(clazz.cast(this.senderIpAddress()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "VpcInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceName()));
            }
            case "WhitelistCidr": {
                return Optional.ofNullable(clazz.cast(this.whitelistCidr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowSourceRequest, T> g) {
        return obj -> g.apply((UpdateFlowSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private UpdateEncryption decryption;
        private String description;
        private String entitlementArn;
        private String flowArn;
        private Integer ingestPort;
        private Integer maxBitrate;
        private Integer maxLatency;
        private Integer maxSyncBuffer;
        private List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Integer minLatency;
        private String protocol;
        private Integer senderControlPort;
        private String senderIpAddress;
        private String sourceArn;
        private String streamId;
        private String vpcInterfaceName;
        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowSourceRequest model) {
            super(model);
            this.decryption(model.decryption);
            this.description(model.description);
            this.entitlementArn(model.entitlementArn);
            this.flowArn(model.flowArn);
            this.ingestPort(model.ingestPort);
            this.maxBitrate(model.maxBitrate);
            this.maxLatency(model.maxLatency);
            this.maxSyncBuffer(model.maxSyncBuffer);
            this.mediaStreamSourceConfigurations(model.mediaStreamSourceConfigurations);
            this.minLatency(model.minLatency);
            this.protocol(model.protocol);
            this.senderControlPort(model.senderControlPort);
            this.senderIpAddress(model.senderIpAddress);
            this.sourceArn(model.sourceArn);
            this.streamId(model.streamId);
            this.vpcInterfaceName(model.vpcInterfaceName);
            this.whitelistCidr(model.whitelistCidr);
        }

        public final UpdateEncryption.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        public final void setDecryption(UpdateEncryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        @Transient
        public final Builder decryption(UpdateEncryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        @Transient
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        @Transient
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final Integer getIngestPort() {
            return this.ingestPort;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        @Override
        @Transient
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        @Transient
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        @Override
        @Transient
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final Integer getMaxSyncBuffer() {
            return this.maxSyncBuffer;
        }

        public final void setMaxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
        }

        @Override
        @Transient
        public final Builder maxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
            return this;
        }

        public final List<MediaStreamSourceConfigurationRequest.Builder> getMediaStreamSourceConfigurations() {
            List<MediaStreamSourceConfigurationRequest.Builder> result = ___listOfMediaStreamSourceConfigurationRequestCopier.copyToBuilder(this.mediaStreamSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest.BuilderImpl> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier.copyFromBuilder(mediaStreamSourceConfigurations);
        }

        @Override
        @Transient
        public final Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier.copy(mediaStreamSourceConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(MediaStreamSourceConfigurationRequest ... mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations(Arrays.asList(mediaStreamSourceConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(Consumer<MediaStreamSourceConfigurationRequest.Builder> ... mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations(Stream.of(mediaStreamSourceConfigurations).map(c -> (MediaStreamSourceConfigurationRequest)((MediaStreamSourceConfigurationRequest.Builder)MediaStreamSourceConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinLatency() {
            return this.minLatency;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        @Override
        @Transient
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getSenderControlPort() {
            return this.senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        @Transient
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final String getSenderIpAddress() {
            return this.senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        @Transient
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        @Transient
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getVpcInterfaceName() {
            return this.vpcInterfaceName;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        @Transient
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final String getWhitelistCidr() {
            return this.whitelistCidr;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        @Transient
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowSourceRequest build() {
            return new UpdateFlowSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowSourceRequest> {
        public Builder decryption(UpdateEncryption var1);

        default public Builder decryption(Consumer<UpdateEncryption.Builder> decryption) {
            return this.decryption((UpdateEncryption)((UpdateEncryption.Builder)UpdateEncryption.builder().applyMutation(decryption)).build());
        }

        public Builder description(String var1);

        public Builder entitlementArn(String var1);

        public Builder flowArn(String var1);

        public Builder ingestPort(Integer var1);

        public Builder maxBitrate(Integer var1);

        public Builder maxLatency(Integer var1);

        public Builder maxSyncBuffer(Integer var1);

        public Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest> var1);

        public Builder mediaStreamSourceConfigurations(MediaStreamSourceConfigurationRequest ... var1);

        public Builder mediaStreamSourceConfigurations(Consumer<MediaStreamSourceConfigurationRequest.Builder> ... var1);

        public Builder minLatency(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder senderControlPort(Integer var1);

        public Builder senderIpAddress(String var1);

        public Builder sourceArn(String var1);

        public Builder streamId(String var1);

        public Builder vpcInterfaceName(String var1);

        public Builder whitelistCidr(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

