/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaStream;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMediaStreamCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddFlowMediaStreamsResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, AddFlowMediaStreamsResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(AddFlowMediaStreamsResponse.getter(AddFlowMediaStreamsResponse::flowArn)).setter(AddFlowMediaStreamsResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<List<MediaStream>> MEDIA_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreams").getter(AddFlowMediaStreamsResponse.getter(AddFlowMediaStreamsResponse::mediaStreams)).setter(AddFlowMediaStreamsResponse.setter(Builder::mediaStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, MEDIA_STREAMS_FIELD));
    private final String flowArn;
    private final List<MediaStream> mediaStreams;

    private AddFlowMediaStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.mediaStreams = builder.mediaStreams;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasMediaStreams() {
        return this.mediaStreams != null && !(this.mediaStreams instanceof SdkAutoConstructList);
    }

    public final List<MediaStream> mediaStreams() {
        return this.mediaStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreams() ? this.mediaStreams() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowMediaStreamsResponse)) {
            return false;
        }
        AddFlowMediaStreamsResponse other = (AddFlowMediaStreamsResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && this.hasMediaStreams() == other.hasMediaStreams() && Objects.equals(this.mediaStreams(), other.mediaStreams());
    }

    public final String toString() {
        return ToString.builder((String)"AddFlowMediaStreamsResponse").add("FlowArn", (Object)this.flowArn()).add("MediaStreams", this.hasMediaStreams() ? this.mediaStreams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MediaStreams": {
                return Optional.ofNullable(clazz.cast(this.mediaStreams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddFlowMediaStreamsResponse, T> g) {
        return obj -> g.apply((AddFlowMediaStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<MediaStream> mediaStreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowMediaStreamsResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.mediaStreams(model.mediaStreams);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        @Transient
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<MediaStream.Builder> getMediaStreams() {
            List<MediaStream.Builder> result = ___listOfMediaStreamCopier.copyToBuilder(this.mediaStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreams(Collection<MediaStream.BuilderImpl> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copyFromBuilder(mediaStreams);
        }

        @Override
        @Transient
        public final Builder mediaStreams(Collection<MediaStream> mediaStreams) {
            this.mediaStreams = ___listOfMediaStreamCopier.copy(mediaStreams);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreams(MediaStream ... mediaStreams) {
            this.mediaStreams(Arrays.asList(mediaStreams));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaStreams(Consumer<MediaStream.Builder> ... mediaStreams) {
            this.mediaStreams(Stream.of(mediaStreams).map(c -> (MediaStream)((MediaStream.Builder)MediaStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddFlowMediaStreamsResponse build() {
            return new AddFlowMediaStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddFlowMediaStreamsResponse> {
        public Builder flowArn(String var1);

        public Builder mediaStreams(Collection<MediaStream> var1);

        public Builder mediaStreams(MediaStream ... var1);

        public Builder mediaStreams(Consumer<MediaStream.Builder> ... var1);
    }
}

