/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.DestinationConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.EncodingName;
import software.amazon.awssdk.services.mediaconnect.model.EncodingParameters;
import software.amazon.awssdk.services.mediaconnect.model.___listOfDestinationConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaStreamOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaStreamOutputConfiguration> {
    private static final SdkField<List<DestinationConfiguration>> DESTINATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationConfigurations").getter(MediaStreamOutputConfiguration.getter(MediaStreamOutputConfiguration::destinationConfigurations)).setter(MediaStreamOutputConfiguration.setter(Builder::destinationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENCODING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncodingName").getter(MediaStreamOutputConfiguration.getter(MediaStreamOutputConfiguration::encodingNameAsString)).setter(MediaStreamOutputConfiguration.setter(Builder::encodingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingName").build()}).build();
    private static final SdkField<EncodingParameters> ENCODING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncodingParameters").getter(MediaStreamOutputConfiguration.getter(MediaStreamOutputConfiguration::encodingParameters)).setter(MediaStreamOutputConfiguration.setter(Builder::encodingParameters)).constructor(EncodingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encodingParameters").build()}).build();
    private static final SdkField<String> MEDIA_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaStreamName").getter(MediaStreamOutputConfiguration.getter(MediaStreamOutputConfiguration::mediaStreamName)).setter(MediaStreamOutputConfiguration.setter(Builder::mediaStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CONFIGURATIONS_FIELD, ENCODING_NAME_FIELD, ENCODING_PARAMETERS_FIELD, MEDIA_STREAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DestinationConfiguration> destinationConfigurations;
    private final String encodingName;
    private final EncodingParameters encodingParameters;
    private final String mediaStreamName;

    private MediaStreamOutputConfiguration(BuilderImpl builder) {
        this.destinationConfigurations = builder.destinationConfigurations;
        this.encodingName = builder.encodingName;
        this.encodingParameters = builder.encodingParameters;
        this.mediaStreamName = builder.mediaStreamName;
    }

    public final boolean hasDestinationConfigurations() {
        return this.destinationConfigurations != null && !(this.destinationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DestinationConfiguration> destinationConfigurations() {
        return this.destinationConfigurations;
    }

    public final EncodingName encodingName() {
        return EncodingName.fromValue(this.encodingName);
    }

    public final String encodingNameAsString() {
        return this.encodingName;
    }

    public final EncodingParameters encodingParameters() {
        return this.encodingParameters;
    }

    public final String mediaStreamName() {
        return this.mediaStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationConfigurations() ? this.destinationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaStreamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamOutputConfiguration)) {
            return false;
        }
        MediaStreamOutputConfiguration other = (MediaStreamOutputConfiguration)obj;
        return this.hasDestinationConfigurations() == other.hasDestinationConfigurations() && Objects.equals(this.destinationConfigurations(), other.destinationConfigurations()) && Objects.equals(this.encodingNameAsString(), other.encodingNameAsString()) && Objects.equals(this.encodingParameters(), other.encodingParameters()) && Objects.equals(this.mediaStreamName(), other.mediaStreamName());
    }

    public final String toString() {
        return ToString.builder((String)"MediaStreamOutputConfiguration").add("DestinationConfigurations", this.hasDestinationConfigurations() ? this.destinationConfigurations() : null).add("EncodingName", (Object)this.encodingNameAsString()).add("EncodingParameters", (Object)this.encodingParameters()).add("MediaStreamName", (Object)this.mediaStreamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.destinationConfigurations()));
            }
            case "EncodingName": {
                return Optional.ofNullable(clazz.cast(this.encodingNameAsString()));
            }
            case "EncodingParameters": {
                return Optional.ofNullable(clazz.cast(this.encodingParameters()));
            }
            case "MediaStreamName": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamOutputConfiguration, T> g) {
        return obj -> g.apply((MediaStreamOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DestinationConfiguration> destinationConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String encodingName;
        private EncodingParameters encodingParameters;
        private String mediaStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamOutputConfiguration model) {
            this.destinationConfigurations(model.destinationConfigurations);
            this.encodingName(model.encodingName);
            this.encodingParameters(model.encodingParameters);
            this.mediaStreamName(model.mediaStreamName);
        }

        public final List<DestinationConfiguration.Builder> getDestinationConfigurations() {
            List<DestinationConfiguration.Builder> result = ___listOfDestinationConfigurationCopier.copyToBuilder(this.destinationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationConfigurations(Collection<DestinationConfiguration.BuilderImpl> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationCopier.copyFromBuilder(destinationConfigurations);
        }

        @Override
        @Transient
        public final Builder destinationConfigurations(Collection<DestinationConfiguration> destinationConfigurations) {
            this.destinationConfigurations = ___listOfDestinationConfigurationCopier.copy(destinationConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinationConfigurations(DestinationConfiguration ... destinationConfigurations) {
            this.destinationConfigurations(Arrays.asList(destinationConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinationConfigurations(Consumer<DestinationConfiguration.Builder> ... destinationConfigurations) {
            this.destinationConfigurations(Stream.of(destinationConfigurations).map(c -> (DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEncodingName() {
            return this.encodingName;
        }

        public final void setEncodingName(String encodingName) {
            this.encodingName = encodingName;
        }

        @Override
        @Transient
        public final Builder encodingName(String encodingName) {
            this.encodingName = encodingName;
            return this;
        }

        @Override
        @Transient
        public final Builder encodingName(EncodingName encodingName) {
            this.encodingName(encodingName == null ? null : encodingName.toString());
            return this;
        }

        public final EncodingParameters.Builder getEncodingParameters() {
            return this.encodingParameters != null ? this.encodingParameters.toBuilder() : null;
        }

        public final void setEncodingParameters(EncodingParameters.BuilderImpl encodingParameters) {
            this.encodingParameters = encodingParameters != null ? encodingParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder encodingParameters(EncodingParameters encodingParameters) {
            this.encodingParameters = encodingParameters;
            return this;
        }

        public final String getMediaStreamName() {
            return this.mediaStreamName;
        }

        public final void setMediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
        }

        @Override
        @Transient
        public final Builder mediaStreamName(String mediaStreamName) {
            this.mediaStreamName = mediaStreamName;
            return this;
        }

        public MediaStreamOutputConfiguration build() {
            return new MediaStreamOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaStreamOutputConfiguration> {
        public Builder destinationConfigurations(Collection<DestinationConfiguration> var1);

        public Builder destinationConfigurations(DestinationConfiguration ... var1);

        public Builder destinationConfigurations(Consumer<DestinationConfiguration.Builder> ... var1);

        public Builder encodingName(String var1);

        public Builder encodingName(EncodingName var1);

        public Builder encodingParameters(EncodingParameters var1);

        default public Builder encodingParameters(Consumer<EncodingParameters.Builder> encodingParameters) {
            return this.encodingParameters((EncodingParameters)((EncodingParameters.Builder)EncodingParameters.builder().applyMutation(encodingParameters)).build());
        }

        public Builder mediaStreamName(String var1);
    }
}

