/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkInterfaceType {
    ENA("ena"),
    EFA("efa"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkInterfaceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkInterfaceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceType> knownValues() {
        return Stream.of(NetworkInterfaceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

