/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScanMode {
    PROGRESSIVE("progressive"),
    INTERLACE("interlace"),
    PROGRESSIVE_SEGMENTED_FRAME("progressive-segmented-frame"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScanMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScanMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanMode> knownValues() {
        return Stream.of(ScanMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

