/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfigurationRequest;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMediaStreamSourceConfigurationRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetSourceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SetSourceRequest> {
    private static final SdkField<Encryption> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Decryption").getter(SetSourceRequest.getter(SetSourceRequest::decryption)).setter(SetSourceRequest.setter(Builder::decryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SetSourceRequest.getter(SetSourceRequest::description)).setter(SetSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementArn").getter(SetSourceRequest.getter(SetSourceRequest::entitlementArn)).setter(SetSourceRequest.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IngestPort").getter(SetSourceRequest.getter(SetSourceRequest::ingestPort)).setter(SetSourceRequest.setter(Builder::ingestPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(SetSourceRequest.getter(SetSourceRequest::maxBitrate)).setter(SetSourceRequest.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLatency").getter(SetSourceRequest.getter(SetSourceRequest::maxLatency)).setter(SetSourceRequest.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<Integer> MAX_SYNC_BUFFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSyncBuffer").getter(SetSourceRequest.getter(SetSourceRequest::maxSyncBuffer)).setter(SetSourceRequest.setter(Builder::maxSyncBuffer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSyncBuffer").build()}).build();
    private static final SdkField<List<MediaStreamSourceConfigurationRequest>> MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreamSourceConfigurations").getter(SetSourceRequest.getter(SetSourceRequest::mediaStreamSourceConfigurations)).setter(SetSourceRequest.setter(Builder::mediaStreamSourceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamSourceConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStreamSourceConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinLatency").getter(SetSourceRequest.getter(SetSourceRequest::minLatency)).setter(SetSourceRequest.setter(Builder::minLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SetSourceRequest.getter(SetSourceRequest::name)).setter(SetSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(SetSourceRequest.getter(SetSourceRequest::protocolAsString)).setter(SetSourceRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(SetSourceRequest.getter(SetSourceRequest::streamId)).setter(SetSourceRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcInterfaceName").getter(SetSourceRequest.getter(SetSourceRequest::vpcInterfaceName)).setter(SetSourceRequest.setter(Builder::vpcInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()}).build();
    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhitelistCidr").getter(SetSourceRequest.getter(SetSourceRequest::whitelistCidr)).setter(SetSourceRequest.setter(Builder::whitelistCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD, DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, INGEST_PORT_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, MAX_SYNC_BUFFER_FIELD, MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD, MIN_LATENCY_FIELD, NAME_FIELD, PROTOCOL_FIELD, STREAM_ID_FIELD, VPC_INTERFACE_NAME_FIELD, WHITELIST_CIDR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Encryption decryption;
    private final String description;
    private final String entitlementArn;
    private final Integer ingestPort;
    private final Integer maxBitrate;
    private final Integer maxLatency;
    private final Integer maxSyncBuffer;
    private final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations;
    private final Integer minLatency;
    private final String name;
    private final String protocol;
    private final String streamId;
    private final String vpcInterfaceName;
    private final String whitelistCidr;

    private SetSourceRequest(BuilderImpl builder) {
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.ingestPort = builder.ingestPort;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.maxSyncBuffer = builder.maxSyncBuffer;
        this.mediaStreamSourceConfigurations = builder.mediaStreamSourceConfigurations;
        this.minLatency = builder.minLatency;
        this.name = builder.name;
        this.protocol = builder.protocol;
        this.streamId = builder.streamId;
        this.vpcInterfaceName = builder.vpcInterfaceName;
        this.whitelistCidr = builder.whitelistCidr;
    }

    public final Encryption decryption() {
        return this.decryption;
    }

    public final String description() {
        return this.description;
    }

    public final String entitlementArn() {
        return this.entitlementArn;
    }

    public final Integer ingestPort() {
        return this.ingestPort;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer maxLatency() {
        return this.maxLatency;
    }

    public final Integer maxSyncBuffer() {
        return this.maxSyncBuffer;
    }

    public final boolean hasMediaStreamSourceConfigurations() {
        return this.mediaStreamSourceConfigurations != null && !(this.mediaStreamSourceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations() {
        return this.mediaStreamSourceConfigurations;
    }

    public final Integer minLatency() {
        return this.minLatency;
    }

    public final String name() {
        return this.name;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final String vpcInterfaceName() {
        return this.vpcInterfaceName;
    }

    public final String whitelistCidr() {
        return this.whitelistCidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSyncBuffer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreamSourceConfigurations() ? this.mediaStreamSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistCidr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSourceRequest)) {
            return false;
        }
        SetSourceRequest other = (SetSourceRequest)obj;
        return Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.ingestPort(), other.ingestPort()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.maxSyncBuffer(), other.maxSyncBuffer()) && this.hasMediaStreamSourceConfigurations() == other.hasMediaStreamSourceConfigurations() && Objects.equals(this.mediaStreamSourceConfigurations(), other.mediaStreamSourceConfigurations()) && Objects.equals(this.minLatency(), other.minLatency()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.vpcInterfaceName(), other.vpcInterfaceName()) && Objects.equals(this.whitelistCidr(), other.whitelistCidr());
    }

    public final String toString() {
        return ToString.builder((String)"SetSourceRequest").add("Decryption", (Object)this.decryption()).add("Description", (Object)this.description()).add("EntitlementArn", (Object)this.entitlementArn()).add("IngestPort", (Object)this.ingestPort()).add("MaxBitrate", (Object)this.maxBitrate()).add("MaxLatency", (Object)this.maxLatency()).add("MaxSyncBuffer", (Object)this.maxSyncBuffer()).add("MediaStreamSourceConfigurations", this.hasMediaStreamSourceConfigurations() ? this.mediaStreamSourceConfigurations() : null).add("MinLatency", (Object)this.minLatency()).add("Name", (Object)this.name()).add("Protocol", (Object)this.protocolAsString()).add("StreamId", (Object)this.streamId()).add("VpcInterfaceName", (Object)this.vpcInterfaceName()).add("WhitelistCidr", (Object)this.whitelistCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "IngestPort": {
                return Optional.ofNullable(clazz.cast(this.ingestPort()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "MaxSyncBuffer": {
                return Optional.ofNullable(clazz.cast(this.maxSyncBuffer()));
            }
            case "MediaStreamSourceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamSourceConfigurations()));
            }
            case "MinLatency": {
                return Optional.ofNullable(clazz.cast(this.minLatency()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "VpcInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceName()));
            }
            case "WhitelistCidr": {
                return Optional.ofNullable(clazz.cast(this.whitelistCidr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSourceRequest, T> g) {
        return obj -> g.apply((SetSourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Encryption decryption;
        private String description;
        private String entitlementArn;
        private Integer ingestPort;
        private Integer maxBitrate;
        private Integer maxLatency;
        private Integer maxSyncBuffer;
        private List<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Integer minLatency;
        private String name;
        private String protocol;
        private String streamId;
        private String vpcInterfaceName;
        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSourceRequest model) {
            this.decryption(model.decryption);
            this.description(model.description);
            this.entitlementArn(model.entitlementArn);
            this.ingestPort(model.ingestPort);
            this.maxBitrate(model.maxBitrate);
            this.maxLatency(model.maxLatency);
            this.maxSyncBuffer(model.maxSyncBuffer);
            this.mediaStreamSourceConfigurations(model.mediaStreamSourceConfigurations);
            this.minLatency(model.minLatency);
            this.name(model.name);
            this.protocol(model.protocol);
            this.streamId(model.streamId);
            this.vpcInterfaceName(model.vpcInterfaceName);
            this.whitelistCidr(model.whitelistCidr);
        }

        public final Encryption.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        @Override
        public final Builder decryption(Encryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final void setDecryption(Encryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final Integer getIngestPort() {
            return this.ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final Integer getMaxSyncBuffer() {
            return this.maxSyncBuffer;
        }

        @Override
        public final Builder maxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
            return this;
        }

        public final void setMaxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
        }

        public final List<MediaStreamSourceConfigurationRequest.Builder> getMediaStreamSourceConfigurations() {
            List<MediaStreamSourceConfigurationRequest.Builder> result = ___listOfMediaStreamSourceConfigurationRequestCopier.copyToBuilder(this.mediaStreamSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier.copy(mediaStreamSourceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(MediaStreamSourceConfigurationRequest ... mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations(Arrays.asList(mediaStreamSourceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(Consumer<MediaStreamSourceConfigurationRequest.Builder> ... mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations(Stream.of(mediaStreamSourceConfigurations).map(c -> (MediaStreamSourceConfigurationRequest)((MediaStreamSourceConfigurationRequest.Builder)MediaStreamSourceConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest.BuilderImpl> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationRequestCopier.copyFromBuilder(mediaStreamSourceConfigurations);
        }

        public final Integer getMinLatency() {
            return this.minLatency;
        }

        @Override
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getVpcInterfaceName() {
            return this.vpcInterfaceName;
        }

        @Override
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        public final String getWhitelistCidr() {
            return this.whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        public SetSourceRequest build() {
            return new SetSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SetSourceRequest> {
        public Builder decryption(Encryption var1);

        default public Builder decryption(Consumer<Encryption.Builder> decryption) {
            return this.decryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(decryption)).build());
        }

        public Builder description(String var1);

        public Builder entitlementArn(String var1);

        public Builder ingestPort(Integer var1);

        public Builder maxBitrate(Integer var1);

        public Builder maxLatency(Integer var1);

        public Builder maxSyncBuffer(Integer var1);

        public Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfigurationRequest> var1);

        public Builder mediaStreamSourceConfigurations(MediaStreamSourceConfigurationRequest ... var1);

        public Builder mediaStreamSourceConfigurations(Consumer<MediaStreamSourceConfigurationRequest.Builder> ... var1);

        public Builder minLatency(Integer var1);

        public Builder name(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder streamId(String var1);

        public Builder vpcInterfaceName(String var1);

        public Builder whitelistCidr(String var1);
    }
}

