/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailoverConfig> {
    private static final SdkField<Integer> RECOVERY_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecoveryWindow").getter(FailoverConfig.getter(FailoverConfig::recoveryWindow)).setter(FailoverConfig.setter(Builder::recoveryWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryWindow").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(FailoverConfig.getter(FailoverConfig::stateAsString)).setter(FailoverConfig.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_WINDOW_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer recoveryWindow;
    private final String state;

    private FailoverConfig(BuilderImpl builder) {
        this.recoveryWindow = builder.recoveryWindow;
        this.state = builder.state;
    }

    public final Integer recoveryWindow() {
        return this.recoveryWindow;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverConfig)) {
            return false;
        }
        FailoverConfig other = (FailoverConfig)obj;
        return Objects.equals(this.recoveryWindow(), other.recoveryWindow()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FailoverConfig").add("RecoveryWindow", (Object)this.recoveryWindow()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryWindow": {
                return Optional.ofNullable(clazz.cast(this.recoveryWindow()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverConfig, T> g) {
        return obj -> g.apply((FailoverConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer recoveryWindow;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverConfig model) {
            this.recoveryWindow(model.recoveryWindow);
            this.state(model.state);
        }

        public final Integer getRecoveryWindow() {
            return this.recoveryWindow;
        }

        @Override
        public final Builder recoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
            return this;
        }

        public final void setRecoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public FailoverConfig build() {
            return new FailoverConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailoverConfig> {
        public Builder recoveryWindow(Integer var1);

        public Builder state(String var1);

        public Builder state(State var1);
    }
}

