/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.Protocol;
import software.amazon.awssdk.services.mediaconnect.model.UpdateEncryption;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceAttachment;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowOutputRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateFlowOutputRequest> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrAllowList").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::cidrAllowList)).setter(UpdateFlowOutputRequest.setter(Builder::cidrAllowList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::description)).setter(UpdateFlowOutputRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::destination)).setter(UpdateFlowOutputRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<UpdateEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::encryption)).setter(UpdateFlowOutputRequest.setter(Builder::encryption)).constructor(UpdateEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::flowArn)).setter(UpdateFlowOutputRequest.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()}).build();
    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLatency").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::maxLatency)).setter(UpdateFlowOutputRequest.setter(Builder::maxLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()}).build();
    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputArn").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::outputArn)).setter(UpdateFlowOutputRequest.setter(Builder::outputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("outputArn").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::port)).setter(UpdateFlowOutputRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::protocolAsString)).setter(UpdateFlowOutputRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteId").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::remoteId)).setter(UpdateFlowOutputRequest.setter(Builder::remoteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()}).build();
    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SmoothingLatency").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::smoothingLatency)).setter(UpdateFlowOutputRequest.setter(Builder::smoothingLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::streamId)).setter(UpdateFlowOutputRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<VpcInterfaceAttachment> VPC_INTERFACE_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcInterfaceAttachment").getter(UpdateFlowOutputRequest.getter(UpdateFlowOutputRequest::vpcInterfaceAttachment)).setter(UpdateFlowOutputRequest.setter(Builder::vpcInterfaceAttachment)).constructor(VpcInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceAttachment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD, DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD, FLOW_ARN_FIELD, MAX_LATENCY_FIELD, OUTPUT_ARN_FIELD, PORT_FIELD, PROTOCOL_FIELD, REMOTE_ID_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD, VPC_INTERFACE_ATTACHMENT_FIELD));
    private final List<String> cidrAllowList;
    private final String description;
    private final String destination;
    private final UpdateEncryption encryption;
    private final String flowArn;
    private final Integer maxLatency;
    private final String outputArn;
    private final Integer port;
    private final String protocol;
    private final String remoteId;
    private final Integer smoothingLatency;
    private final String streamId;
    private final VpcInterfaceAttachment vpcInterfaceAttachment;

    private UpdateFlowOutputRequest(BuilderImpl builder) {
        super(builder);
        this.cidrAllowList = builder.cidrAllowList;
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.flowArn = builder.flowArn;
        this.maxLatency = builder.maxLatency;
        this.outputArn = builder.outputArn;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
        this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
    }

    public boolean hasCidrAllowList() {
        return this.cidrAllowList != null && !(this.cidrAllowList instanceof SdkAutoConstructList);
    }

    public List<String> cidrAllowList() {
        return this.cidrAllowList;
    }

    public String description() {
        return this.description;
    }

    public String destination() {
        return this.destination;
    }

    public UpdateEncryption encryption() {
        return this.encryption;
    }

    public String flowArn() {
        return this.flowArn;
    }

    public Integer maxLatency() {
        return this.maxLatency;
    }

    public String outputArn() {
        return this.outputArn;
    }

    public Integer port() {
        return this.port;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public String remoteId() {
        return this.remoteId;
    }

    public Integer smoothingLatency() {
        return this.smoothingLatency;
    }

    public String streamId() {
        return this.streamId;
    }

    public VpcInterfaceAttachment vpcInterfaceAttachment() {
        return this.vpcInterfaceAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrAllowList());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceAttachment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowOutputRequest)) {
            return false;
        }
        UpdateFlowOutputRequest other = (UpdateFlowOutputRequest)((Object)obj);
        return Objects.equals(this.cidrAllowList(), other.cidrAllowList()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.maxLatency(), other.maxLatency()) && Objects.equals(this.outputArn(), other.outputArn()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.remoteId(), other.remoteId()) && Objects.equals(this.smoothingLatency(), other.smoothingLatency()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.vpcInterfaceAttachment(), other.vpcInterfaceAttachment());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFlowOutputRequest").add("CidrAllowList", this.cidrAllowList()).add("Description", (Object)this.description()).add("Destination", (Object)this.destination()).add("Encryption", (Object)this.encryption()).add("FlowArn", (Object)this.flowArn()).add("MaxLatency", (Object)this.maxLatency()).add("OutputArn", (Object)this.outputArn()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("RemoteId", (Object)this.remoteId()).add("SmoothingLatency", (Object)this.smoothingLatency()).add("StreamId", (Object)this.streamId()).add("VpcInterfaceAttachment", (Object)this.vpcInterfaceAttachment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrAllowList": {
                return Optional.ofNullable(clazz.cast(this.cidrAllowList()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "MaxLatency": {
                return Optional.ofNullable(clazz.cast(this.maxLatency()));
            }
            case "OutputArn": {
                return Optional.ofNullable(clazz.cast(this.outputArn()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "RemoteId": {
                return Optional.ofNullable(clazz.cast(this.remoteId()));
            }
            case "SmoothingLatency": {
                return Optional.ofNullable(clazz.cast(this.smoothingLatency()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "VpcInterfaceAttachment": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceAttachment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowOutputRequest, T> g) {
        return obj -> g.apply((UpdateFlowOutputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String destination;
        private UpdateEncryption encryption;
        private String flowArn;
        private Integer maxLatency;
        private String outputArn;
        private Integer port;
        private String protocol;
        private String remoteId;
        private Integer smoothingLatency;
        private String streamId;
        private VpcInterfaceAttachment vpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowOutputRequest model) {
            super(model);
            this.cidrAllowList(model.cidrAllowList);
            this.description(model.description);
            this.destination(model.destination);
            this.encryption(model.encryption);
            this.flowArn(model.flowArn);
            this.maxLatency(model.maxLatency);
            this.outputArn(model.outputArn);
            this.port(model.port);
            this.protocol(model.protocol);
            this.remoteId(model.remoteId);
            this.smoothingLatency(model.smoothingLatency);
            this.streamId(model.streamId);
            this.vpcInterfaceAttachment(model.vpcInterfaceAttachment);
        }

        public final Collection<String> getCidrAllowList() {
            return this.cidrAllowList;
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String ... cidrAllowList) {
            this.cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final UpdateEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(UpdateEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(UpdateEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Integer getMaxLatency() {
            return this.maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getOutputArn() {
            return this.outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRemoteId() {
            return this.remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public final Integer getSmoothingLatency() {
            return this.smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final VpcInterfaceAttachment.Builder getVpcInterfaceAttachment() {
            return this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.toBuilder() : null;
        }

        @Override
        public final Builder vpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment;
            return this;
        }

        public final void setVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl vpcInterfaceAttachment) {
            this.vpcInterfaceAttachment = vpcInterfaceAttachment != null ? vpcInterfaceAttachment.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowOutputRequest build() {
            return new UpdateFlowOutputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowOutputRequest> {
        public Builder cidrAllowList(Collection<String> var1);

        public Builder cidrAllowList(String ... var1);

        public Builder description(String var1);

        public Builder destination(String var1);

        public Builder encryption(UpdateEncryption var1);

        default public Builder encryption(Consumer<UpdateEncryption.Builder> encryption) {
            return this.encryption((UpdateEncryption)((UpdateEncryption.Builder)UpdateEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder flowArn(String var1);

        public Builder maxLatency(Integer var1);

        public Builder outputArn(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder remoteId(String var1);

        public Builder smoothingLatency(Integer var1);

        public Builder streamId(String var1);

        public Builder vpcInterfaceAttachment(VpcInterfaceAttachment var1);

        default public Builder vpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> vpcInterfaceAttachment) {
            return this.vpcInterfaceAttachment((VpcInterfaceAttachment)((VpcInterfaceAttachment.Builder)VpcInterfaceAttachment.builder().applyMutation(vpcInterfaceAttachment)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

