/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.EntitlementStatus;
import software.amazon.awssdk.services.mediaconnect.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entitlement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entitlement> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataTransferSubscriberFeePercent").getter(Entitlement.getter(Entitlement::dataTransferSubscriberFeePercent)).setter(Entitlement.setter(Builder::dataTransferSubscriberFeePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Entitlement.getter(Entitlement::description)).setter(Entitlement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(Entitlement.getter(Entitlement::encryption)).setter(Entitlement.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementArn").getter(Entitlement.getter(Entitlement::entitlementArn)).setter(Entitlement.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> ENTITLEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementStatus").getter(Entitlement.getter(Entitlement::entitlementStatusAsString)).setter(Entitlement.setter(Builder::entitlementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementStatus").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Entitlement.getter(Entitlement::name)).setter(Entitlement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(Entitlement.getter(Entitlement::subscribers)).setter(Entitlement.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DESCRIPTION_FIELD, ENCRYPTION_FIELD, ENTITLEMENT_ARN_FIELD, ENTITLEMENT_STATUS_FIELD, NAME_FIELD, SUBSCRIBERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dataTransferSubscriberFeePercent;
    private final String description;
    private final Encryption encryption;
    private final String entitlementArn;
    private final String entitlementStatus;
    private final String name;
    private final List<String> subscribers;

    private Entitlement(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementArn = builder.entitlementArn;
        this.entitlementStatus = builder.entitlementStatus;
        this.name = builder.name;
        this.subscribers = builder.subscribers;
    }

    public Integer dataTransferSubscriberFeePercent() {
        return this.dataTransferSubscriberFeePercent;
    }

    public String description() {
        return this.description;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public String entitlementArn() {
        return this.entitlementArn;
    }

    public EntitlementStatus entitlementStatus() {
        return EntitlementStatus.fromValue(this.entitlementStatus);
    }

    public String entitlementStatusAsString() {
        return this.entitlementStatus;
    }

    public String name() {
        return this.name;
    }

    public boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public List<String> subscribers() {
        return this.subscribers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        return Objects.equals(this.dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.entitlementStatusAsString(), other.entitlementStatusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.subscribers(), other.subscribers());
    }

    public String toString() {
        return ToString.builder((String)"Entitlement").add("DataTransferSubscriberFeePercent", (Object)this.dataTransferSubscriberFeePercent()).add("Description", (Object)this.description()).add("Encryption", (Object)this.encryption()).add("EntitlementArn", (Object)this.entitlementArn()).add("EntitlementStatus", (Object)this.entitlementStatusAsString()).add("Name", (Object)this.name()).add("Subscribers", this.subscribers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTransferSubscriberFeePercent": {
                return Optional.ofNullable(clazz.cast(this.dataTransferSubscriberFeePercent()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "EntitlementStatus": {
                return Optional.ofNullable(clazz.cast(this.entitlementStatusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dataTransferSubscriberFeePercent;
        private String description;
        private Encryption encryption;
        private String entitlementArn;
        private String entitlementStatus;
        private String name;
        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            this.dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            this.description(model.description);
            this.encryption(model.encryption);
            this.entitlementArn(model.entitlementArn);
            this.entitlementStatus(model.entitlementStatus);
            this.name(model.name);
            this.subscribers(model.subscribers);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return this.dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getEntitlementStatus() {
            return this.entitlementStatus;
        }

        @Override
        public final Builder entitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        @Override
        public final Builder entitlementStatus(EntitlementStatus entitlementStatus) {
            this.entitlementStatus(entitlementStatus == null ? null : entitlementStatus.toString());
            return this;
        }

        public final void setEntitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSubscribers() {
            return this.subscribers;
        }

        @Override
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(String ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        public Entitlement build() {
            return new Entitlement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entitlement> {
        public Builder dataTransferSubscriberFeePercent(Integer var1);

        public Builder description(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder entitlementArn(String var1);

        public Builder entitlementStatus(String var1);

        public Builder entitlementStatus(EntitlementStatus var1);

        public Builder name(String var1);

        public Builder subscribers(Collection<String> var1);

        public Builder subscribers(String ... var1);
    }
}

