/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFailoverConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateFailoverConfig> {
    private static final SdkField<Integer> RECOVERY_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateFailoverConfig.getter(UpdateFailoverConfig::recoveryWindow)).setter(UpdateFailoverConfig.setter(Builder::recoveryWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryWindow").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFailoverConfig.getter(UpdateFailoverConfig::stateAsString)).setter(UpdateFailoverConfig.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_WINDOW_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer recoveryWindow;
    private final String state;

    private UpdateFailoverConfig(BuilderImpl builder) {
        this.recoveryWindow = builder.recoveryWindow;
        this.state = builder.state;
    }

    public Integer recoveryWindow() {
        return this.recoveryWindow;
    }

    public State state() {
        return State.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFailoverConfig)) {
            return false;
        }
        UpdateFailoverConfig other = (UpdateFailoverConfig)obj;
        return Objects.equals(this.recoveryWindow(), other.recoveryWindow()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFailoverConfig").add("RecoveryWindow", (Object)this.recoveryWindow()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryWindow": {
                return Optional.ofNullable(clazz.cast(this.recoveryWindow()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFailoverConfig, T> g) {
        return obj -> g.apply((UpdateFailoverConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer recoveryWindow;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFailoverConfig model) {
            this.recoveryWindow(model.recoveryWindow);
            this.state(model.state);
        }

        public final Integer getRecoveryWindow() {
            return this.recoveryWindow;
        }

        @Override
        public final Builder recoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
            return this;
        }

        public final void setRecoveryWindow(Integer recoveryWindow) {
            this.recoveryWindow = recoveryWindow;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public UpdateFailoverConfig build() {
            return new UpdateFailoverConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateFailoverConfig> {
        public Builder recoveryWindow(Integer var1);

        public Builder state(String var1);

        public Builder state(State var1);
    }
}

