/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.Transport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Source.getter(Source::dataTransferSubscriberFeePercent)).setter(Source.setter(Builder::dataTransferSubscriberFeePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent").build()}).build();
    private static final SdkField<Encryption> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Source.getter(Source::decryption)).setter(Source.setter(Builder::decryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::description)).setter(Source.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::entitlementArn)).setter(Source.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> INGEST_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::ingestIp)).setter(Source.setter(Builder::ingestIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestIp").build()}).build();
    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Source.getter(Source::ingestPort)).setter(Source.setter(Builder::ingestPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::name)).setter(Source.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::sourceArn)).setter(Source.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<Transport> TRANSPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Source.getter(Source::transport)).setter(Source.setter(Builder::transport)).constructor(Transport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transport").build()}).build();
    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Source.getter(Source::whitelistCidr)).setter(Source.setter(Builder::whitelistCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DECRYPTION_FIELD, DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, INGEST_IP_FIELD, INGEST_PORT_FIELD, NAME_FIELD, SOURCE_ARN_FIELD, TRANSPORT_FIELD, WHITELIST_CIDR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dataTransferSubscriberFeePercent;
    private final Encryption decryption;
    private final String description;
    private final String entitlementArn;
    private final String ingestIp;
    private final Integer ingestPort;
    private final String name;
    private final String sourceArn;
    private final Transport transport;
    private final String whitelistCidr;

    private Source(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.ingestIp = builder.ingestIp;
        this.ingestPort = builder.ingestPort;
        this.name = builder.name;
        this.sourceArn = builder.sourceArn;
        this.transport = builder.transport;
        this.whitelistCidr = builder.whitelistCidr;
    }

    public Integer dataTransferSubscriberFeePercent() {
        return this.dataTransferSubscriberFeePercent;
    }

    public Encryption decryption() {
        return this.decryption;
    }

    public String description() {
        return this.description;
    }

    public String entitlementArn() {
        return this.entitlementArn;
    }

    public String ingestIp() {
        return this.ingestIp;
    }

    public Integer ingestPort() {
        return this.ingestPort;
    }

    public String name() {
        return this.name;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public Transport transport() {
        return this.transport;
    }

    public String whitelistCidr() {
        return this.whitelistCidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transport());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistCidr());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent()) && Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.ingestIp(), other.ingestIp()) && Objects.equals(this.ingestPort(), other.ingestPort()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.transport(), other.transport()) && Objects.equals(this.whitelistCidr(), other.whitelistCidr());
    }

    public String toString() {
        return ToString.builder((String)"Source").add("DataTransferSubscriberFeePercent", (Object)this.dataTransferSubscriberFeePercent()).add("Decryption", (Object)this.decryption()).add("Description", (Object)this.description()).add("EntitlementArn", (Object)this.entitlementArn()).add("IngestIp", (Object)this.ingestIp()).add("IngestPort", (Object)this.ingestPort()).add("Name", (Object)this.name()).add("SourceArn", (Object)this.sourceArn()).add("Transport", (Object)this.transport()).add("WhitelistCidr", (Object)this.whitelistCidr()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTransferSubscriberFeePercent": {
                return Optional.ofNullable(clazz.cast(this.dataTransferSubscriberFeePercent()));
            }
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "IngestIp": {
                return Optional.ofNullable(clazz.cast(this.ingestIp()));
            }
            case "IngestPort": {
                return Optional.ofNullable(clazz.cast(this.ingestPort()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "Transport": {
                return Optional.ofNullable(clazz.cast(this.transport()));
            }
            case "WhitelistCidr": {
                return Optional.ofNullable(clazz.cast(this.whitelistCidr()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dataTransferSubscriberFeePercent;
        private Encryption decryption;
        private String description;
        private String entitlementArn;
        private String ingestIp;
        private Integer ingestPort;
        private String name;
        private String sourceArn;
        private Transport transport;
        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            this.decryption(model.decryption);
            this.description(model.description);
            this.entitlementArn(model.entitlementArn);
            this.ingestIp(model.ingestIp);
            this.ingestPort(model.ingestPort);
            this.name(model.name);
            this.sourceArn(model.sourceArn);
            this.transport(model.transport);
            this.whitelistCidr(model.whitelistCidr);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return this.dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        public final Encryption.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        @Override
        public final Builder decryption(Encryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final void setDecryption(Encryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getIngestIp() {
            return this.ingestIp;
        }

        @Override
        public final Builder ingestIp(String ingestIp) {
            this.ingestIp = ingestIp;
            return this;
        }

        public final void setIngestIp(String ingestIp) {
            this.ingestIp = ingestIp;
        }

        public final Integer getIngestPort() {
            return this.ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final Transport.Builder getTransport() {
            return this.transport != null ? this.transport.toBuilder() : null;
        }

        @Override
        public final Builder transport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public final void setTransport(Transport.BuilderImpl transport) {
            this.transport = transport != null ? transport.build() : null;
        }

        public final String getWhitelistCidr() {
            return this.whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder dataTransferSubscriberFeePercent(Integer var1);

        public Builder decryption(Encryption var1);

        default public Builder decryption(Consumer<Encryption.Builder> decryption) {
            return this.decryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(decryption)).build());
        }

        public Builder description(String var1);

        public Builder entitlementArn(String var1);

        public Builder ingestIp(String var1);

        public Builder ingestPort(Integer var1);

        public Builder name(String var1);

        public Builder sourceArn(String var1);

        public Builder transport(Transport var1);

        default public Builder transport(Consumer<Transport.Builder> transport) {
            return this.transport((Transport)((Transport.Builder)Transport.builder().applyMutation(transport)).build());
        }

        public Builder whitelistCidr(String var1);
    }
}

