/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.AddOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.SetSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.___listOfAddOutputRequestCopier;
import software.amazon.awssdk.services.mediaconnect.model.___listOfGrantEntitlementRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, CreateFlowRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowRequest.getter(CreateFlowRequest::availabilityZone)).setter(CreateFlowRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<List<GrantEntitlementRequest>> ENTITLEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFlowRequest.getter(CreateFlowRequest::entitlements)).setter(CreateFlowRequest.setter(Builder::entitlements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrantEntitlementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowRequest.getter(CreateFlowRequest::name)).setter(CreateFlowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<AddOutputRequest>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFlowRequest.getter(CreateFlowRequest::outputs)).setter(CreateFlowRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOutputRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SetSourceRequest> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateFlowRequest.getter(CreateFlowRequest::source)).setter(CreateFlowRequest.setter(Builder::source)).constructor(SetSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, ENTITLEMENTS_FIELD, NAME_FIELD, OUTPUTS_FIELD, SOURCE_FIELD));
    private final String availabilityZone;
    private final List<GrantEntitlementRequest> entitlements;
    private final String name;
    private final List<AddOutputRequest> outputs;
    private final SetSourceRequest source;

    private CreateFlowRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.entitlements = builder.entitlements;
        this.name = builder.name;
        this.outputs = builder.outputs;
        this.source = builder.source;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public boolean hasEntitlements() {
        return this.entitlements != null && !(this.entitlements instanceof SdkAutoConstructList);
    }

    public List<GrantEntitlementRequest> entitlements() {
        return this.entitlements;
    }

    public String name() {
        return this.name;
    }

    public boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public List<AddOutputRequest> outputs() {
        return this.outputs;
    }

    public SetSourceRequest source() {
        return this.source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlements());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowRequest)) {
            return false;
        }
        CreateFlowRequest other = (CreateFlowRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.entitlements(), other.entitlements()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.source(), other.source());
    }

    public String toString() {
        return ToString.builder((String)"CreateFlowRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Entitlements", this.entitlements()).add("Name", (Object)this.name()).add("Outputs", this.outputs()).add("Source", (Object)this.source()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Entitlements": {
                return Optional.ofNullable(clazz.cast(this.entitlements()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowRequest, T> g) {
        return obj -> g.apply((CreateFlowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<GrantEntitlementRequest> entitlements = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<AddOutputRequest> outputs = DefaultSdkAutoConstructList.getInstance();
        private SetSourceRequest source;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.entitlements(model.entitlements);
            this.name(model.name);
            this.outputs(model.outputs);
            this.source(model.source);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<GrantEntitlementRequest.Builder> getEntitlements() {
            return this.entitlements != null ? (Collection)this.entitlements.stream().map(GrantEntitlementRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitlements(Collection<GrantEntitlementRequest> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(GrantEntitlementRequest ... entitlements) {
            this.entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<GrantEntitlementRequest.Builder> ... entitlements) {
            this.entitlements(Stream.of(entitlements).map(c -> (GrantEntitlementRequest)((GrantEntitlementRequest.Builder)GrantEntitlementRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitlements(Collection<GrantEntitlementRequest.BuilderImpl> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copyFromBuilder(entitlements);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<AddOutputRequest.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(AddOutputRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<AddOutputRequest> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AddOutputRequest ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AddOutputRequest.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (AddOutputRequest)((AddOutputRequest.Builder)AddOutputRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<AddOutputRequest.BuilderImpl> outputs) {
            this.outputs = ___listOfAddOutputRequestCopier.copyFromBuilder(outputs);
        }

        public final SetSourceRequest.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(SetSourceRequest source) {
            this.source = source;
            return this;
        }

        public final void setSource(SetSourceRequest.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowRequest build() {
            return new CreateFlowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowRequest> {
        public Builder availabilityZone(String var1);

        public Builder entitlements(Collection<GrantEntitlementRequest> var1);

        public Builder entitlements(GrantEntitlementRequest ... var1);

        public Builder entitlements(Consumer<GrantEntitlementRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder outputs(Collection<AddOutputRequest> var1);

        public Builder outputs(AddOutputRequest ... var1);

        public Builder outputs(Consumer<AddOutputRequest.Builder> ... var1);

        public Builder source(SetSourceRequest var1);

        default public Builder source(Consumer<SetSourceRequest.Builder> source) {
            return this.source((SetSourceRequest)((SetSourceRequest.Builder)SetSourceRequest.builder().applyMutation(source)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

