/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeterUsageRequest
extends MarketplaceMeteringRequest
implements ToCopyableBuilder<Builder, MeterUsageRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MeterUsageRequest.getter(MeterUsageRequest::productCode)).setter(MeterUsageRequest.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MeterUsageRequest.getter(MeterUsageRequest::timestamp)).setter(MeterUsageRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> USAGE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MeterUsageRequest.getter(MeterUsageRequest::usageDimension)).setter(MeterUsageRequest.setter(Builder::usageDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageDimension").build()}).build();
    private static final SdkField<Integer> USAGE_QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MeterUsageRequest.getter(MeterUsageRequest::usageQuantity)).setter(MeterUsageRequest.setter(Builder::usageQuantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageQuantity").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MeterUsageRequest.getter(MeterUsageRequest::dryRun)).setter(MeterUsageRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD, TIMESTAMP_FIELD, USAGE_DIMENSION_FIELD, USAGE_QUANTITY_FIELD, DRY_RUN_FIELD));
    private final String productCode;
    private final Instant timestamp;
    private final String usageDimension;
    private final Integer usageQuantity;
    private final Boolean dryRun;

    private MeterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.timestamp = builder.timestamp;
        this.usageDimension = builder.usageDimension;
        this.usageQuantity = builder.usageQuantity;
        this.dryRun = builder.dryRun;
    }

    public String productCode() {
        return this.productCode;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String usageDimension() {
        return this.usageDimension;
    }

    public Integer usageQuantity() {
        return this.usageQuantity;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageDimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeterUsageRequest)) {
            return false;
        }
        MeterUsageRequest other = (MeterUsageRequest)((Object)obj);
        return Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.usageDimension(), other.usageDimension()) && Objects.equals(this.usageQuantity(), other.usageQuantity()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"MeterUsageRequest").add("ProductCode", (Object)this.productCode()).add("Timestamp", (Object)this.timestamp()).add("UsageDimension", (Object)this.usageDimension()).add("UsageQuantity", (Object)this.usageQuantity()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "UsageDimension": {
                return Optional.ofNullable(clazz.cast(this.usageDimension()));
            }
            case "UsageQuantity": {
                return Optional.ofNullable(clazz.cast(this.usageQuantity()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeterUsageRequest, T> g) {
        return obj -> g.apply((MeterUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringRequest.BuilderImpl
    implements Builder {
        private String productCode;
        private Instant timestamp;
        private String usageDimension;
        private Integer usageQuantity;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(MeterUsageRequest model) {
            super(model);
            this.productCode(model.productCode);
            this.timestamp(model.timestamp);
            this.usageDimension(model.usageDimension);
            this.usageQuantity(model.usageQuantity);
            this.dryRun(model.dryRun);
        }

        public final String getProductCode() {
            return this.productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getUsageDimension() {
            return this.usageDimension;
        }

        @Override
        public final Builder usageDimension(String usageDimension) {
            this.usageDimension = usageDimension;
            return this;
        }

        public final void setUsageDimension(String usageDimension) {
            this.usageDimension = usageDimension;
        }

        public final Integer getUsageQuantity() {
            return this.usageQuantity;
        }

        @Override
        public final Builder usageQuantity(Integer usageQuantity) {
            this.usageQuantity = usageQuantity;
            return this;
        }

        public final void setUsageQuantity(Integer usageQuantity) {
            this.usageQuantity = usageQuantity;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MeterUsageRequest build() {
            return new MeterUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceMeteringRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MeterUsageRequest> {
        public Builder productCode(String var1);

        public Builder timestamp(Instant var1);

        public Builder usageDimension(String var1);

        public Builder usageQuantity(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

