/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringResponse;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecord;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecordListCopier;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecordResult;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecordResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchMeterUsageResponse
extends MarketplaceMeteringResponse
implements ToCopyableBuilder<Builder, BatchMeterUsageResponse> {
    private static final SdkField<List<UsageRecordResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchMeterUsageResponse.getter(BatchMeterUsageResponse::results)).setter(BatchMeterUsageResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageRecordResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UsageRecord>> UNPROCESSED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchMeterUsageResponse.getter(BatchMeterUsageResponse::unprocessedRecords)).setter(BatchMeterUsageResponse.setter(Builder::unprocessedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, UNPROCESSED_RECORDS_FIELD));
    private final List<UsageRecordResult> results;
    private final List<UsageRecord> unprocessedRecords;

    private BatchMeterUsageResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.unprocessedRecords = builder.unprocessedRecords;
    }

    public List<UsageRecordResult> results() {
        return this.results;
    }

    public List<UsageRecord> unprocessedRecords() {
        return this.unprocessedRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.results());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMeterUsageResponse)) {
            return false;
        }
        BatchMeterUsageResponse other = (BatchMeterUsageResponse)((Object)obj);
        return Objects.equals(this.results(), other.results()) && Objects.equals(this.unprocessedRecords(), other.unprocessedRecords());
    }

    public String toString() {
        return ToString.builder((String)"BatchMeterUsageResponse").add("Results", this.results()).add("UnprocessedRecords", this.unprocessedRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "UnprocessedRecords": {
                return Optional.ofNullable(clazz.cast(this.unprocessedRecords()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchMeterUsageResponse, T> g) {
        return obj -> g.apply((BatchMeterUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringResponse.BuilderImpl
    implements Builder {
        private List<UsageRecordResult> results = DefaultSdkAutoConstructList.getInstance();
        private List<UsageRecord> unprocessedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchMeterUsageResponse model) {
            super(model);
            this.results(model.results);
            this.unprocessedRecords(model.unprocessedRecords);
        }

        public final Collection<UsageRecordResult.Builder> getResults() {
            return this.results != null ? (Collection)this.results.stream().map(UsageRecordResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<UsageRecordResult> results) {
            this.results = UsageRecordResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(UsageRecordResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<UsageRecordResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (UsageRecordResult)((UsageRecordResult.Builder)UsageRecordResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<UsageRecordResult.BuilderImpl> results) {
            this.results = UsageRecordResultListCopier.copyFromBuilder(results);
        }

        public final Collection<UsageRecord.Builder> getUnprocessedRecords() {
            return this.unprocessedRecords != null ? (Collection)this.unprocessedRecords.stream().map(UsageRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedRecords(Collection<UsageRecord> unprocessedRecords) {
            this.unprocessedRecords = UsageRecordListCopier.copy(unprocessedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedRecords(UsageRecord ... unprocessedRecords) {
            this.unprocessedRecords(Arrays.asList(unprocessedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedRecords(Consumer<UsageRecord.Builder> ... unprocessedRecords) {
            this.unprocessedRecords(Stream.of(unprocessedRecords).map(c -> (UsageRecord)((UsageRecord.Builder)UsageRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedRecords(Collection<UsageRecord.BuilderImpl> unprocessedRecords) {
            this.unprocessedRecords = UsageRecordListCopier.copyFromBuilder(unprocessedRecords);
        }

        @Override
        public BatchMeterUsageResponse build() {
            return new BatchMeterUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceMeteringResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchMeterUsageResponse> {
        public Builder results(Collection<UsageRecordResult> var1);

        public Builder results(UsageRecordResult ... var1);

        public Builder results(Consumer<UsageRecordResult.Builder> ... var1);

        public Builder unprocessedRecords(Collection<UsageRecord> var1);

        public Builder unprocessedRecords(UsageRecord ... var1);

        public Builder unprocessedRecords(Consumer<UsageRecord.Builder> ... var1);
    }
}

