/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolveCustomerResponse
extends MarketplaceMeteringResponse
implements ToCopyableBuilder<Builder, ResolveCustomerResponse> {
    private static final SdkField<String> CUSTOMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolveCustomerResponse.getter(ResolveCustomerResponse::customerIdentifier)).setter(ResolveCustomerResponse.setter(Builder::customerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerIdentifier").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolveCustomerResponse.getter(ResolveCustomerResponse::productCode)).setter(ResolveCustomerResponse.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_IDENTIFIER_FIELD, PRODUCT_CODE_FIELD));
    private final String customerIdentifier;
    private final String productCode;

    private ResolveCustomerResponse(BuilderImpl builder) {
        super(builder);
        this.customerIdentifier = builder.customerIdentifier;
        this.productCode = builder.productCode;
    }

    public String customerIdentifier() {
        return this.customerIdentifier;
    }

    public String productCode() {
        return this.productCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveCustomerResponse)) {
            return false;
        }
        ResolveCustomerResponse other = (ResolveCustomerResponse)((Object)obj);
        return Objects.equals(this.customerIdentifier(), other.customerIdentifier()) && Objects.equals(this.productCode(), other.productCode());
    }

    public String toString() {
        return ToString.builder((String)"ResolveCustomerResponse").add("CustomerIdentifier", (Object)this.customerIdentifier()).add("ProductCode", (Object)this.productCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customerIdentifier()));
            }
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveCustomerResponse, T> g) {
        return obj -> g.apply((ResolveCustomerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringResponse.BuilderImpl
    implements Builder {
        private String customerIdentifier;
        private String productCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveCustomerResponse model) {
            super(model);
            this.customerIdentifier(model.customerIdentifier);
            this.productCode(model.productCode);
        }

        public final String getCustomerIdentifier() {
            return this.customerIdentifier;
        }

        @Override
        public final Builder customerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
            return this;
        }

        public final void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public ResolveCustomerResponse build() {
            return new ResolveCustomerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceMeteringResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResolveCustomerResponse> {
        public Builder customerIdentifier(String var1);

        public Builder productCode(String var1);
    }
}

