/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacemetering.model.UsageAllocation;
import software.amazon.awssdk.services.marketplacemetering.model.UsageAllocationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageRecord> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(UsageRecord.getter(UsageRecord::timestamp)).setter(UsageRecord.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> CUSTOMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerIdentifier").getter(UsageRecord.getter(UsageRecord::customerIdentifier)).setter(UsageRecord.setter(Builder::customerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerIdentifier").build()}).build();
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dimension").getter(UsageRecord.getter(UsageRecord::dimension)).setter(UsageRecord.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(UsageRecord.getter(UsageRecord::quantity)).setter(UsageRecord.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()}).build();
    private static final SdkField<List<UsageAllocation>> USAGE_ALLOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UsageAllocations").getter(UsageRecord.getter(UsageRecord::usageAllocations)).setter(UsageRecord.setter(Builder::usageAllocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageAllocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageAllocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, CUSTOMER_IDENTIFIER_FIELD, DIMENSION_FIELD, QUANTITY_FIELD, USAGE_ALLOCATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final String customerIdentifier;
    private final String dimension;
    private final Integer quantity;
    private final List<UsageAllocation> usageAllocations;

    private UsageRecord(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.customerIdentifier = builder.customerIdentifier;
        this.dimension = builder.dimension;
        this.quantity = builder.quantity;
        this.usageAllocations = builder.usageAllocations;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String customerIdentifier() {
        return this.customerIdentifier;
    }

    public final String dimension() {
        return this.dimension;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final boolean hasUsageAllocations() {
        return this.usageAllocations != null && !(this.usageAllocations instanceof SdkAutoConstructList);
    }

    public final List<UsageAllocation> usageAllocations() {
        return this.usageAllocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageAllocations() ? this.usageAllocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.customerIdentifier(), other.customerIdentifier()) && Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.quantity(), other.quantity()) && this.hasUsageAllocations() == other.hasUsageAllocations() && Objects.equals(this.usageAllocations(), other.usageAllocations());
    }

    public final String toString() {
        return ToString.builder((String)"UsageRecord").add("Timestamp", (Object)this.timestamp()).add("CustomerIdentifier", (Object)this.customerIdentifier()).add("Dimension", (Object)this.dimension()).add("Quantity", (Object)this.quantity()).add("UsageAllocations", this.hasUsageAllocations() ? this.usageAllocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "CustomerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customerIdentifier()));
            }
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "UsageAllocations": {
                return Optional.ofNullable(clazz.cast(this.usageAllocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageRecord, T> g) {
        return obj -> g.apply((UsageRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private String customerIdentifier;
        private String dimension;
        private Integer quantity;
        private List<UsageAllocation> usageAllocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecord model) {
            this.timestamp(model.timestamp);
            this.customerIdentifier(model.customerIdentifier);
            this.dimension(model.dimension);
            this.quantity(model.quantity);
            this.usageAllocations(model.usageAllocations);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getCustomerIdentifier() {
            return this.customerIdentifier;
        }

        public final void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        @Override
        @Transient
        public final Builder customerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
            return this;
        }

        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        @Transient
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        @Transient
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<UsageAllocation.Builder> getUsageAllocations() {
            List<UsageAllocation.Builder> result = UsageAllocationsCopier.copyToBuilder(this.usageAllocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageAllocations(Collection<UsageAllocation.BuilderImpl> usageAllocations) {
            this.usageAllocations = UsageAllocationsCopier.copyFromBuilder(usageAllocations);
        }

        @Override
        @Transient
        public final Builder usageAllocations(Collection<UsageAllocation> usageAllocations) {
            this.usageAllocations = UsageAllocationsCopier.copy(usageAllocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usageAllocations(UsageAllocation ... usageAllocations) {
            this.usageAllocations(Arrays.asList(usageAllocations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usageAllocations(Consumer<UsageAllocation.Builder> ... usageAllocations) {
            this.usageAllocations(Stream.of(usageAllocations).map(c -> (UsageAllocation)((UsageAllocation.Builder)UsageAllocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UsageRecord build() {
            return new UsageRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageRecord> {
        public Builder timestamp(Instant var1);

        public Builder customerIdentifier(String var1);

        public Builder dimension(String var1);

        public Builder quantity(Integer var1);

        public Builder usageAllocations(Collection<UsageAllocation> var1);

        public Builder usageAllocations(UsageAllocation ... var1);

        public Builder usageAllocations(Consumer<UsageAllocation.Builder> ... var1);
    }
}

