/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolveCustomerResponse
extends MarketplaceMeteringResponse
implements ToCopyableBuilder<Builder, ResolveCustomerResponse> {
    private static final SdkField<String> CUSTOMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerIdentifier").getter(ResolveCustomerResponse.getter(ResolveCustomerResponse::customerIdentifier)).setter(ResolveCustomerResponse.setter(Builder::customerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerIdentifier").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(ResolveCustomerResponse.getter(ResolveCustomerResponse::productCode)).setter(ResolveCustomerResponse.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<String> CUSTOMER_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerAWSAccountId").getter(ResolveCustomerResponse.getter(ResolveCustomerResponse::customerAWSAccountId)).setter(ResolveCustomerResponse.setter(Builder::customerAWSAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAWSAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_IDENTIFIER_FIELD, PRODUCT_CODE_FIELD, CUSTOMER_AWS_ACCOUNT_ID_FIELD));
    private final String customerIdentifier;
    private final String productCode;
    private final String customerAWSAccountId;

    private ResolveCustomerResponse(BuilderImpl builder) {
        super(builder);
        this.customerIdentifier = builder.customerIdentifier;
        this.productCode = builder.productCode;
        this.customerAWSAccountId = builder.customerAWSAccountId;
    }

    public final String customerIdentifier() {
        return this.customerIdentifier;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final String customerAWSAccountId() {
        return this.customerAWSAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAWSAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveCustomerResponse)) {
            return false;
        }
        ResolveCustomerResponse other = (ResolveCustomerResponse)((Object)obj);
        return Objects.equals(this.customerIdentifier(), other.customerIdentifier()) && Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.customerAWSAccountId(), other.customerAWSAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"ResolveCustomerResponse").add("CustomerIdentifier", (Object)this.customerIdentifier()).add("ProductCode", (Object)this.productCode()).add("CustomerAWSAccountId", (Object)this.customerAWSAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customerIdentifier()));
            }
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "CustomerAWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.customerAWSAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolveCustomerResponse, T> g) {
        return obj -> g.apply((ResolveCustomerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceMeteringResponse.BuilderImpl
    implements Builder {
        private String customerIdentifier;
        private String productCode;
        private String customerAWSAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveCustomerResponse model) {
            super(model);
            this.customerIdentifier(model.customerIdentifier);
            this.productCode(model.productCode);
            this.customerAWSAccountId(model.customerAWSAccountId);
        }

        public final String getCustomerIdentifier() {
            return this.customerIdentifier;
        }

        public final void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        @Override
        @Transient
        public final Builder customerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
            return this;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        @Transient
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getCustomerAWSAccountId() {
            return this.customerAWSAccountId;
        }

        public final void setCustomerAWSAccountId(String customerAWSAccountId) {
            this.customerAWSAccountId = customerAWSAccountId;
        }

        @Override
        @Transient
        public final Builder customerAWSAccountId(String customerAWSAccountId) {
            this.customerAWSAccountId = customerAWSAccountId;
            return this;
        }

        @Override
        public ResolveCustomerResponse build() {
            return new ResolveCustomerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceMeteringResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResolveCustomerResponse> {
        public Builder customerIdentifier(String var1);

        public Builder productCode(String var1);

        public Builder customerAWSAccountId(String var1);
    }
}

