/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeterUsageResponse extends MarketplaceMeteringResponse implements
        ToCopyableBuilder<MeterUsageResponse.Builder, MeterUsageResponse> {
    private static final SdkField<String> METERING_RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeteringRecordId").getter(getter(MeterUsageResponse::meteringRecordId))
            .setter(setter(Builder::meteringRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringRecordId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METERING_RECORD_ID_FIELD));

    private final String meteringRecordId;

    private MeterUsageResponse(BuilderImpl builder) {
        super(builder);
        this.meteringRecordId = builder.meteringRecordId;
    }

    /**
     * <p>
     * Metering record id.
     * </p>
     * 
     * @return Metering record id.
     */
    public final String meteringRecordId() {
        return meteringRecordId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meteringRecordId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeterUsageResponse)) {
            return false;
        }
        MeterUsageResponse other = (MeterUsageResponse) obj;
        return Objects.equals(meteringRecordId(), other.meteringRecordId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeterUsageResponse").add("MeteringRecordId", meteringRecordId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeteringRecordId":
            return Optional.ofNullable(clazz.cast(meteringRecordId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeterUsageResponse, T> g) {
        return obj -> g.apply((MeterUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringResponse.Builder, SdkPojo, CopyableBuilder<Builder, MeterUsageResponse> {
        /**
         * <p>
         * Metering record id.
         * </p>
         * 
         * @param meteringRecordId
         *        Metering record id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meteringRecordId(String meteringRecordId);
    }

    static final class BuilderImpl extends MarketplaceMeteringResponse.BuilderImpl implements Builder {
        private String meteringRecordId;

        private BuilderImpl() {
        }

        private BuilderImpl(MeterUsageResponse model) {
            super(model);
            meteringRecordId(model.meteringRecordId);
        }

        public final String getMeteringRecordId() {
            return meteringRecordId;
        }

        @Override
        public final Builder meteringRecordId(String meteringRecordId) {
            this.meteringRecordId = meteringRecordId;
            return this;
        }

        public final void setMeteringRecordId(String meteringRecordId) {
            this.meteringRecordId = meteringRecordId;
        }

        @Override
        public MeterUsageResponse build() {
            return new MeterUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
