/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.CustomerNotEntitledException;
import software.amazon.awssdk.services.marketplacemetering.model.DisabledApiException;
import software.amazon.awssdk.services.marketplacemetering.model.DuplicateRequestException;
import software.amazon.awssdk.services.marketplacemetering.model.ExpiredTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InternalServiceErrorException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidCustomerIdentifierException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidEndpointRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidProductCodeException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidPublicKeyVersionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidTagException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidUsageAllocationsException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidUsageDimensionException;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringException;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.PlatformNotSupportedException;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerRequest;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ThrottlingException;
import software.amazon.awssdk.services.marketplacemetering.model.TimestampOutOfBoundsException;

/**
 * Service client for accessing AWSMarketplace Metering. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Marketplace Metering Service</fullname>
 * <p>
 * This reference provides descriptions of the low-level AWS Marketplace Metering Service API.
 * </p>
 * <p>
 * AWS Marketplace sellers can use this API to submit usage data for custom usage dimensions.
 * </p>
 * <p>
 * For information on the permissions you need to use this API, see <a
 * href="https://docs.aws.amazon.com/marketplace/latest/userguide/iam-user-policy-for-aws-marketplace-actions.html">AWS
 * Marketing metering and entitlement API permissions</a> in the <i>AWS Marketplace Seller Guide.</i>
 * </p>
 * <p>
 * <b>Submitting Metering Records</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>MeterUsage</i>- Submits the metering record for a Marketplace product. MeterUsage is called from an EC2 instance
 * or a container running on EKS or ECS.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>BatchMeterUsage</i>- Submits the metering record for a set of customers. BatchMeterUsage is called from a
 * software-as-a-service (SaaS) application.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Accepting New Customers</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>ResolveCustomer</i>- Called by a SaaS application during the registration process. When a buyer visits your
 * website during the registration process, the buyer submits a Registration Token through the browser. The Registration
 * Token is resolved through this API to obtain a CustomerIdentifier and Product Code.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Entitlement and Metering for Paid Container Products</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering
 * Service and call the RegisterUsage operation for software entitlement and metering. Free and BYOL products for Amazon
 * ECS or Amazon EKS aren't required to call RegisterUsage, but you can do so if you want to receive usage data in your
 * seller reports. For more information on using the RegisterUsage operation, see <a
 * href="https://docs.aws.amazon.com/marketplace/latest/userguide/container-based-products.html">Container-Based
 * Products</a>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * BatchMeterUsage API calls are captured by AWS CloudTrail. You can use Cloudtrail to verify that the SaaS metering
 * records that you sent are accurate by searching for records with the eventName of BatchMeterUsage. You can also use
 * CloudTrail to audit records over time. For more information, see the <i> <a
 * href="http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html">AWS CloudTrail User
 * Guide</a> </i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface MarketplaceMeteringClient extends SdkClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Create a {@link MarketplaceMeteringClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceMeteringClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceMeteringClient}.
     */
    static MarketplaceMeteringClientBuilder builder() {
        return new DefaultMarketplaceMeteringClientBuilder();
    }

    /**
     * <p>
     * BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to post metering records for a
     * set of customers.
     * </p>
     * <p>
     * For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the
     * input records.
     * </p>
     * <p>
     * Every request to BatchMeterUsage is for one product. If you need to meter usage for multiple products, you must
     * make multiple calls to BatchMeterUsage.
     * </p>
     * <p>
     * BatchMeterUsage can process up to 25 UsageRecords at a time.
     * </p>
     * <p>
     * A UsageRecord can optionally include multiple usage allocations, to provide customers with usagedata split into
     * buckets by tags that you define (or allow the customer to define).
     * </p>
     * <p>
     * BatchMeterUsage requests must be less than 1MB in size.
     * </p>
     *
     * @param batchMeterUsageRequest
     *        A BatchMeterUsageRequest contains UsageRecords, which indicate quantities of usage within your
     *        application.
     * @return Result of the BatchMeterUsage operation returned by the service.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws InvalidProductCodeException
     *         The product code passed does not match the product code used for publishing the product.
     * @throws InvalidUsageDimensionException
     *         The usage dimension does not match one of the UsageDimensions associated with products.
     * @throws InvalidTagException
     *         The tag is invalid, or the number of tags is greater than 5.
     * @throws InvalidUsageAllocationsException
     *         The usage allocation objects are invalid, or the number of allocations is greater than 500 for a single
     *         usage record.
     * @throws InvalidCustomerIdentifierException
     *         You have metered usage for a CustomerIdentifier that does not exist.
     * @throws TimestampOutOfBoundsException
     *         The timestamp value passed in the meterUsage() is out of allowed range.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws DisabledApiException
     *         The API is disabled in the Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.BatchMeterUsage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/BatchMeterUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchMeterUsageResponse batchMeterUsage(BatchMeterUsageRequest batchMeterUsageRequest)
            throws InternalServiceErrorException, InvalidProductCodeException, InvalidUsageDimensionException,
            InvalidTagException, InvalidUsageAllocationsException, InvalidCustomerIdentifierException,
            TimestampOutOfBoundsException, ThrottlingException, DisabledApiException, AwsServiceException, SdkClientException,
            MarketplaceMeteringException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * BatchMeterUsage is called from a SaaS application listed on the AWS Marketplace to post metering records for a
     * set of customers.
     * </p>
     * <p>
     * For identical requests, the API is idempotent; requests can be retried with the same records or a subset of the
     * input records.
     * </p>
     * <p>
     * Every request to BatchMeterUsage is for one product. If you need to meter usage for multiple products, you must
     * make multiple calls to BatchMeterUsage.
     * </p>
     * <p>
     * BatchMeterUsage can process up to 25 UsageRecords at a time.
     * </p>
     * <p>
     * A UsageRecord can optionally include multiple usage allocations, to provide customers with usagedata split into
     * buckets by tags that you define (or allow the customer to define).
     * </p>
     * <p>
     * BatchMeterUsage requests must be less than 1MB in size.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchMeterUsageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchMeterUsageRequest#builder()}
     * </p>
     *
     * @param batchMeterUsageRequest
     *        A {@link Consumer} that will call methods on {@link BatchMeterUsageRequest.Builder} to create a request. A
     *        BatchMeterUsageRequest contains UsageRecords, which indicate quantities of usage within your application.
     * @return Result of the BatchMeterUsage operation returned by the service.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws InvalidProductCodeException
     *         The product code passed does not match the product code used for publishing the product.
     * @throws InvalidUsageDimensionException
     *         The usage dimension does not match one of the UsageDimensions associated with products.
     * @throws InvalidTagException
     *         The tag is invalid, or the number of tags is greater than 5.
     * @throws InvalidUsageAllocationsException
     *         The usage allocation objects are invalid, or the number of allocations is greater than 500 for a single
     *         usage record.
     * @throws InvalidCustomerIdentifierException
     *         You have metered usage for a CustomerIdentifier that does not exist.
     * @throws TimestampOutOfBoundsException
     *         The timestamp value passed in the meterUsage() is out of allowed range.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws DisabledApiException
     *         The API is disabled in the Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.BatchMeterUsage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/BatchMeterUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchMeterUsageResponse batchMeterUsage(Consumer<BatchMeterUsageRequest.Builder> batchMeterUsageRequest)
            throws InternalServiceErrorException, InvalidProductCodeException, InvalidUsageDimensionException,
            InvalidTagException, InvalidUsageAllocationsException, InvalidCustomerIdentifierException,
            TimestampOutOfBoundsException, ThrottlingException, DisabledApiException, AwsServiceException, SdkClientException,
            MarketplaceMeteringException {
        return batchMeterUsage(BatchMeterUsageRequest.builder().applyMutation(batchMeterUsageRequest).build());
    }

    /**
     * <p>
     * API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering
     * record ID.
     * </p>
     * <p>
     * MeterUsage is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS
     * pod.
     * </p>
     * <p>
     * MeterUsage can optionally include multiple usage allocations, to provide customers with usage data split into
     * buckets by tags that you define (or allow the customer to define).
     * </p>
     *
     * @param meterUsageRequest
     * @return Result of the MeterUsage operation returned by the service.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws InvalidProductCodeException
     *         The product code passed does not match the product code used for publishing the product.
     * @throws InvalidUsageDimensionException
     *         The usage dimension does not match one of the UsageDimensions associated with products.
     * @throws InvalidTagException
     *         The tag is invalid, or the number of tags is greater than 5.
     * @throws InvalidUsageAllocationsException
     *         The usage allocation objects are invalid, or the number of allocations is greater than 500 for a single
     *         usage record.
     * @throws InvalidEndpointRegionException
     *         The endpoint being called is in a AWS Region different from your EC2 instance, ECS task, or EKS pod. The
     *         Region of the Metering Service endpoint and the AWS Region of the resource must match.
     * @throws TimestampOutOfBoundsException
     *         The timestamp value passed in the meterUsage() is out of allowed range.
     * @throws DuplicateRequestException
     *         A metering record has already been emitted by the same EC2 instance, ECS task, or EKS pod for the given
     *         {usageDimension, timestamp} with a different usageQuantity.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws CustomerNotEntitledException
     *         Exception thrown when the customer does not have a valid subscription for the product.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.MeterUsage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/MeterUsage" target="_top">AWS
     *      API Documentation</a>
     */
    default MeterUsageResponse meterUsage(MeterUsageRequest meterUsageRequest) throws InternalServiceErrorException,
            InvalidProductCodeException, InvalidUsageDimensionException, InvalidTagException, InvalidUsageAllocationsException,
            InvalidEndpointRegionException, TimestampOutOfBoundsException, DuplicateRequestException, ThrottlingException,
            CustomerNotEntitledException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering
     * record ID.
     * </p>
     * <p>
     * MeterUsage is authenticated on the buyer's AWS account using credentials from the EC2 instance, ECS task, or EKS
     * pod.
     * </p>
     * <p>
     * MeterUsage can optionally include multiple usage allocations, to provide customers with usage data split into
     * buckets by tags that you define (or allow the customer to define).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MeterUsageRequest.Builder} avoiding the need to
     * create one manually via {@link MeterUsageRequest#builder()}
     * </p>
     *
     * @param meterUsageRequest
     *        A {@link Consumer} that will call methods on {@link MeterUsageRequest.Builder} to create a request.
     * @return Result of the MeterUsage operation returned by the service.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws InvalidProductCodeException
     *         The product code passed does not match the product code used for publishing the product.
     * @throws InvalidUsageDimensionException
     *         The usage dimension does not match one of the UsageDimensions associated with products.
     * @throws InvalidTagException
     *         The tag is invalid, or the number of tags is greater than 5.
     * @throws InvalidUsageAllocationsException
     *         The usage allocation objects are invalid, or the number of allocations is greater than 500 for a single
     *         usage record.
     * @throws InvalidEndpointRegionException
     *         The endpoint being called is in a AWS Region different from your EC2 instance, ECS task, or EKS pod. The
     *         Region of the Metering Service endpoint and the AWS Region of the resource must match.
     * @throws TimestampOutOfBoundsException
     *         The timestamp value passed in the meterUsage() is out of allowed range.
     * @throws DuplicateRequestException
     *         A metering record has already been emitted by the same EC2 instance, ECS task, or EKS pod for the given
     *         {usageDimension, timestamp} with a different usageQuantity.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws CustomerNotEntitledException
     *         Exception thrown when the customer does not have a valid subscription for the product.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.MeterUsage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/MeterUsage" target="_top">AWS
     *      API Documentation</a>
     */
    default MeterUsageResponse meterUsage(Consumer<MeterUsageRequest.Builder> meterUsageRequest)
            throws InternalServiceErrorException, InvalidProductCodeException, InvalidUsageDimensionException,
            InvalidTagException, InvalidUsageAllocationsException, InvalidEndpointRegionException, TimestampOutOfBoundsException,
            DuplicateRequestException, ThrottlingException, CustomerNotEntitledException, AwsServiceException,
            SdkClientException, MarketplaceMeteringException {
        return meterUsage(MeterUsageRequest.builder().applyMutation(meterUsageRequest).build());
    }

    /**
     * <p>
     * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering
     * Service and call the RegisterUsage operation for software entitlement and metering. Free and BYOL products for
     * Amazon ECS or Amazon EKS aren't required to call RegisterUsage, but you may choose to do so if you would like to
     * receive usage data in your seller reports. The sections below explain the behavior of RegisterUsage.
     * RegisterUsage performs two primary functions: metering and entitlement.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Entitlement</i>: RegisterUsage allows you to verify that the customer running your paid software is subscribed
     * to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that
     * integrates with RegisterUsage is only required to guard against unauthorized use at container startup, as such a
     * CustomerNotSubscribedException/PlatformNotSupportedException will only be thrown on the initial call to
     * RegisterUsage. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not
     * throw a CustomerNotSubscribedException, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS
     * pod is still running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Metering</i>: RegisterUsage meters software use per ECS task, per hour, or per pod for Amazon EKS with usage
     * prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a
     * customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS
     * or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate).
     * Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software
     * is not required to perform any metering specific actions, other than call RegisterUsage once for metering of
     * software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for
     * running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your
     * software to perform entitlement checks at runtime.
     * </p>
     * </li>
     * </ul>
     *
     * @param registerUsageRequest
     * @return Result of the RegisterUsage operation returned by the service.
     * @throws InvalidProductCodeException
     *         The product code passed does not match the product code used for publishing the product.
     * @throws InvalidRegionException
     *         RegisterUsage must be called in the same AWS Region the ECS task was launched in. This prevents a
     *         container from hardcoding a Region (e.g. withRegion(“us-east-1”) when calling RegisterUsage.
     * @throws InvalidPublicKeyVersionException
     *         Public Key version is invalid.
     * @throws PlatformNotSupportedException
     *         AWS Marketplace does not support metering usage from the underlying platform. Currently, Amazon ECS,
     *         Amazon EKS, and AWS Fargate are supported.
     * @throws CustomerNotEntitledException
     *         Exception thrown when the customer does not have a valid subscription for the product.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws DisabledApiException
     *         The API is disabled in the Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.RegisterUsage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/RegisterUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterUsageResponse registerUsage(RegisterUsageRequest registerUsageRequest) throws InvalidProductCodeException,
            InvalidRegionException, InvalidPublicKeyVersionException, PlatformNotSupportedException,
            CustomerNotEntitledException, ThrottlingException, InternalServiceErrorException, DisabledApiException,
            AwsServiceException, SdkClientException, MarketplaceMeteringException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering
     * Service and call the RegisterUsage operation for software entitlement and metering. Free and BYOL products for
     * Amazon ECS or Amazon EKS aren't required to call RegisterUsage, but you may choose to do so if you would like to
     * receive usage data in your seller reports. The sections below explain the behavior of RegisterUsage.
     * RegisterUsage performs two primary functions: metering and entitlement.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Entitlement</i>: RegisterUsage allows you to verify that the customer running your paid software is subscribed
     * to your product on AWS Marketplace, enabling you to guard against unauthorized use. Your container image that
     * integrates with RegisterUsage is only required to guard against unauthorized use at container startup, as such a
     * CustomerNotSubscribedException/PlatformNotSupportedException will only be thrown on the initial call to
     * RegisterUsage. Subsequent calls from the same Amazon ECS task instance (e.g. task-id) or Amazon EKS pod will not
     * throw a CustomerNotSubscribedException, even if the customer unsubscribes while the Amazon ECS task or Amazon EKS
     * pod is still running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Metering</i>: RegisterUsage meters software use per ECS task, per hour, or per pod for Amazon EKS with usage
     * prorated to the second. A minimum of 1 minute of usage applies to tasks that are short lived. For example, if a
     * customer has a 10 node Amazon ECS or Amazon EKS cluster and a service configured as a Daemon Set, then Amazon ECS
     * or Amazon EKS will launch a task on all 10 cluster nodes and the customer will be charged: (10 * hourly_rate).
     * Metering for software use is automatically handled by the AWS Marketplace Metering Control Plane -- your software
     * is not required to perform any metering specific actions, other than call RegisterUsage once for metering of
     * software use to commence. The AWS Marketplace Metering Control Plane will also continue to bill customers for
     * running ECS tasks and Amazon EKS pods, regardless of the customers subscription state, removing the need for your
     * software to perform entitlement checks at runtime.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterUsageRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterUsageRequest#builder()}
     * </p>
     *
     * @param registerUsageRequest
     *        A {@link Consumer} that will call methods on {@link RegisterUsageRequest.Builder} to create a request.
     * @return Result of the RegisterUsage operation returned by the service.
     * @throws InvalidProductCodeException
     *         The product code passed does not match the product code used for publishing the product.
     * @throws InvalidRegionException
     *         RegisterUsage must be called in the same AWS Region the ECS task was launched in. This prevents a
     *         container from hardcoding a Region (e.g. withRegion(“us-east-1”) when calling RegisterUsage.
     * @throws InvalidPublicKeyVersionException
     *         Public Key version is invalid.
     * @throws PlatformNotSupportedException
     *         AWS Marketplace does not support metering usage from the underlying platform. Currently, Amazon ECS,
     *         Amazon EKS, and AWS Fargate are supported.
     * @throws CustomerNotEntitledException
     *         Exception thrown when the customer does not have a valid subscription for the product.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws DisabledApiException
     *         The API is disabled in the Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.RegisterUsage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/RegisterUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterUsageResponse registerUsage(Consumer<RegisterUsageRequest.Builder> registerUsageRequest)
            throws InvalidProductCodeException, InvalidRegionException, InvalidPublicKeyVersionException,
            PlatformNotSupportedException, CustomerNotEntitledException, ThrottlingException, InternalServiceErrorException,
            DisabledApiException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        return registerUsage(RegisterUsageRequest.builder().applyMutation(registerUsageRequest).build());
    }

    /**
     * <p>
     * ResolveCustomer is called by a SaaS application during the registration process. When a buyer visits your website
     * during the registration process, the buyer submits a registration token through their browser. The registration
     * token is resolved through this API to obtain a CustomerIdentifier and product code.
     * </p>
     *
     * @param resolveCustomerRequest
     *        Contains input to the ResolveCustomer operation.
     * @return Result of the ResolveCustomer operation returned by the service.
     * @throws InvalidTokenException
     *         Registration token is invalid.
     * @throws ExpiredTokenException
     *         The submitted registration token has expired. This can happen if the buyer's browser takes too long to
     *         redirect to your page, the buyer has resubmitted the registration token, or your application has held on
     *         to the registration token for too long. Your SaaS registration website should redeem this token as soon
     *         as it is submitted by the buyer's browser.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws DisabledApiException
     *         The API is disabled in the Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.ResolveCustomer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/ResolveCustomer"
     *      target="_top">AWS API Documentation</a>
     */
    default ResolveCustomerResponse resolveCustomer(ResolveCustomerRequest resolveCustomerRequest) throws InvalidTokenException,
            ExpiredTokenException, ThrottlingException, InternalServiceErrorException, DisabledApiException, AwsServiceException,
            SdkClientException, MarketplaceMeteringException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * ResolveCustomer is called by a SaaS application during the registration process. When a buyer visits your website
     * during the registration process, the buyer submits a registration token through their browser. The registration
     * token is resolved through this API to obtain a CustomerIdentifier and product code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveCustomerRequest.Builder} avoiding the need
     * to create one manually via {@link ResolveCustomerRequest#builder()}
     * </p>
     *
     * @param resolveCustomerRequest
     *        A {@link Consumer} that will call methods on {@link ResolveCustomerRequest.Builder} to create a request.
     *        Contains input to the ResolveCustomer operation.
     * @return Result of the ResolveCustomer operation returned by the service.
     * @throws InvalidTokenException
     *         Registration token is invalid.
     * @throws ExpiredTokenException
     *         The submitted registration token has expired. This can happen if the buyer's browser takes too long to
     *         redirect to your page, the buyer has resubmitted the registration token, or your application has held on
     *         to the registration token for too long. Your SaaS registration website should redeem this token as soon
     *         as it is submitted by the buyer's browser.
     * @throws ThrottlingException
     *         The calls to the API are throttled.
     * @throws InternalServiceErrorException
     *         An internal error has occurred. Retry your request. If the problem persists, post a message with details
     *         on the AWS forums.
     * @throws DisabledApiException
     *         The API is disabled in the Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceMeteringException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceMeteringClient.ResolveCustomer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/meteringmarketplace-2016-01-14/ResolveCustomer"
     *      target="_top">AWS API Documentation</a>
     */
    default ResolveCustomerResponse resolveCustomer(Consumer<ResolveCustomerRequest.Builder> resolveCustomerRequest)
            throws InvalidTokenException, ExpiredTokenException, ThrottlingException, InternalServiceErrorException,
            DisabledApiException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        return resolveCustomer(ResolveCustomerRequest.builder().applyMutation(resolveCustomerRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("metering.marketplace");
    }
}
