/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.marketplacemetering.MarketplaceMeteringAsyncClient;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.CustomerNotEntitledException;
import software.amazon.awssdk.services.marketplacemetering.model.DisabledApiException;
import software.amazon.awssdk.services.marketplacemetering.model.DuplicateRequestException;
import software.amazon.awssdk.services.marketplacemetering.model.ExpiredTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InternalServiceErrorException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidCustomerIdentifierException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidEndpointRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidProductCodeException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidPublicKeyVersionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidUsageDimensionException;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringException;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.PlatformNotSupportedException;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerRequest;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ThrottlingException;
import software.amazon.awssdk.services.marketplacemetering.model.TimestampOutOfBoundsException;
import software.amazon.awssdk.services.marketplacemetering.transform.BatchMeterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.MeterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.RegisterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.ResolveCustomerRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMarketplaceMeteringAsyncClient
implements MarketplaceMeteringAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMarketplaceMeteringAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMarketplaceMeteringAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "aws-marketplace";
    }

    @Override
    public CompletableFuture<BatchMeterUsageResponse> batchMeterUsage(BatchMeterUsageRequest batchMeterUsageRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchMeterUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchMeterUsageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchMeterUsage").withMarshaller((Marshaller)new BatchMeterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)batchMeterUsageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchMeterUsageRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchMeterUsageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MeterUsageResponse> meterUsage(MeterUsageRequest meterUsageRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MeterUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MeterUsageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MeterUsage").withMarshaller((Marshaller)new MeterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)meterUsageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = meterUsageRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, meterUsageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterUsageResponse> registerUsage(RegisterUsageRequest registerUsageRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterUsageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterUsage").withMarshaller((Marshaller)new RegisterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)registerUsageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerUsageRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerUsageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResolveCustomerResponse> resolveCustomer(ResolveCustomerRequest resolveCustomerRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Marketplace Metering");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResolveCustomer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveCustomerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResolveCustomer").withMarshaller((Marshaller)new ResolveCustomerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)resolveCustomerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resolveCustomerRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, (RequestOverrideConfiguration)requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        }
        catch (Throwable t) {
            List<MetricPublisher> metricPublishers = DefaultMarketplaceMeteringAsyncClient.resolveMetricPublishers(this.clientConfiguration, resolveCustomerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MarketplaceMeteringException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTokenException").exceptionBuilderSupplier(InvalidTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTokenException").exceptionBuilderSupplier(ExpiredTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointRegionException").exceptionBuilderSupplier(InvalidEndpointRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PlatformNotSupportedException").exceptionBuilderSupplier(PlatformNotSupportedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TimestampOutOfBoundsException").exceptionBuilderSupplier(TimestampOutOfBoundsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidUsageDimensionException").exceptionBuilderSupplier(InvalidUsageDimensionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateRequestException").exceptionBuilderSupplier(DuplicateRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPublicKeyVersionException").exceptionBuilderSupplier(InvalidPublicKeyVersionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRegionException").exceptionBuilderSupplier(InvalidRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomerNotEntitledException").exceptionBuilderSupplier(CustomerNotEntitledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DisabledApiException").exceptionBuilderSupplier(DisabledApiException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCustomerIdentifierException").exceptionBuilderSupplier(InvalidCustomerIdentifierException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidProductCodeException").exceptionBuilderSupplier(InvalidProductCodeException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

