/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.marketplacemetering.MarketplaceMeteringClient;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.BatchMeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.CustomerNotEntitledException;
import software.amazon.awssdk.services.marketplacemetering.model.DisabledApiException;
import software.amazon.awssdk.services.marketplacemetering.model.DuplicateRequestException;
import software.amazon.awssdk.services.marketplacemetering.model.ExpiredTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InternalServiceErrorException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidCustomerIdentifierException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidEndpointRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidProductCodeException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidPublicKeyVersionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidRegionException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidTokenException;
import software.amazon.awssdk.services.marketplacemetering.model.InvalidUsageDimensionException;
import software.amazon.awssdk.services.marketplacemetering.model.MarketplaceMeteringException;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.MeterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.PlatformNotSupportedException;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageRequest;
import software.amazon.awssdk.services.marketplacemetering.model.RegisterUsageResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerRequest;
import software.amazon.awssdk.services.marketplacemetering.model.ResolveCustomerResponse;
import software.amazon.awssdk.services.marketplacemetering.model.ThrottlingException;
import software.amazon.awssdk.services.marketplacemetering.model.TimestampOutOfBoundsException;
import software.amazon.awssdk.services.marketplacemetering.transform.BatchMeterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.MeterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.RegisterUsageRequestMarshaller;
import software.amazon.awssdk.services.marketplacemetering.transform.ResolveCustomerRequestMarshaller;

@SdkInternalApi
final class DefaultMarketplaceMeteringClient
implements MarketplaceMeteringClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMarketplaceMeteringClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "aws-marketplace";
    }

    @Override
    public BatchMeterUsageResponse batchMeterUsage(BatchMeterUsageRequest batchMeterUsageRequest) throws InternalServiceErrorException, InvalidProductCodeException, InvalidUsageDimensionException, InvalidCustomerIdentifierException, TimestampOutOfBoundsException, ThrottlingException, DisabledApiException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchMeterUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchMeterUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchMeterUsageRequest).withMarshaller((Marshaller)new BatchMeterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public MeterUsageResponse meterUsage(MeterUsageRequest meterUsageRequest) throws InternalServiceErrorException, InvalidProductCodeException, InvalidUsageDimensionException, InvalidEndpointRegionException, TimestampOutOfBoundsException, DuplicateRequestException, ThrottlingException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MeterUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (MeterUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)meterUsageRequest).withMarshaller((Marshaller)new MeterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterUsageResponse registerUsage(RegisterUsageRequest registerUsageRequest) throws InvalidProductCodeException, InvalidRegionException, InvalidPublicKeyVersionException, PlatformNotSupportedException, CustomerNotEntitledException, ThrottlingException, InternalServiceErrorException, DisabledApiException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerUsageRequest).withMarshaller((Marshaller)new RegisterUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ResolveCustomerResponse resolveCustomer(ResolveCustomerRequest resolveCustomerRequest) throws InvalidTokenException, ExpiredTokenException, ThrottlingException, InternalServiceErrorException, DisabledApiException, AwsServiceException, SdkClientException, MarketplaceMeteringException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResolveCustomerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ResolveCustomerResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resolveCustomerRequest).withMarshaller((Marshaller)new ResolveCustomerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MarketplaceMeteringException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTokenException").exceptionBuilderSupplier(InvalidTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTokenException").exceptionBuilderSupplier(ExpiredTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEndpointRegionException").exceptionBuilderSupplier(InvalidEndpointRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PlatformNotSupportedException").exceptionBuilderSupplier(PlatformNotSupportedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TimestampOutOfBoundsException").exceptionBuilderSupplier(TimestampOutOfBoundsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidUsageDimensionException").exceptionBuilderSupplier(InvalidUsageDimensionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateRequestException").exceptionBuilderSupplier(DuplicateRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPublicKeyVersionException").exceptionBuilderSupplier(InvalidPublicKeyVersionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRegionException").exceptionBuilderSupplier(InvalidRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CustomerNotEntitledException").exceptionBuilderSupplier(CustomerNotEntitledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DisabledApiException").exceptionBuilderSupplier(DisabledApiException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCustomerIdentifierException").exceptionBuilderSupplier(InvalidCustomerIdentifierException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidProductCodeException").exceptionBuilderSupplier(InvalidProductCodeException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

