/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacemetering.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecord;
import software.amazon.awssdk.services.marketplacemetering.model.UsageRecordResultStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageRecordResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageRecordResult> {
    private static final SdkField<UsageRecord> USAGE_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UsageRecordResult.getter(UsageRecordResult::usageRecord)).setter(UsageRecordResult.setter(Builder::usageRecord)).constructor(UsageRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageRecord").build()}).build();
    private static final SdkField<String> METERING_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageRecordResult.getter(UsageRecordResult::meteringRecordId)).setter(UsageRecordResult.setter(Builder::meteringRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringRecordId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageRecordResult.getter(UsageRecordResult::statusAsString)).setter(UsageRecordResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_RECORD_FIELD, METERING_RECORD_ID_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final UsageRecord usageRecord;
    private final String meteringRecordId;
    private final String status;

    private UsageRecordResult(BuilderImpl builder) {
        this.usageRecord = builder.usageRecord;
        this.meteringRecordId = builder.meteringRecordId;
        this.status = builder.status;
    }

    public UsageRecord usageRecord() {
        return this.usageRecord;
    }

    public String meteringRecordId() {
        return this.meteringRecordId;
    }

    public UsageRecordResultStatus status() {
        return UsageRecordResultStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.meteringRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecordResult)) {
            return false;
        }
        UsageRecordResult other = (UsageRecordResult)obj;
        return Objects.equals(this.usageRecord(), other.usageRecord()) && Objects.equals(this.meteringRecordId(), other.meteringRecordId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UsageRecordResult").add("UsageRecord", (Object)this.usageRecord()).add("MeteringRecordId", (Object)this.meteringRecordId()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageRecord": {
                return Optional.ofNullable(clazz.cast(this.usageRecord()));
            }
            case "MeteringRecordId": {
                return Optional.ofNullable(clazz.cast(this.meteringRecordId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageRecordResult, T> g) {
        return obj -> g.apply((UsageRecordResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UsageRecord usageRecord;
        private String meteringRecordId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecordResult model) {
            this.usageRecord(model.usageRecord);
            this.meteringRecordId(model.meteringRecordId);
            this.status(model.status);
        }

        public final UsageRecord.Builder getUsageRecord() {
            return this.usageRecord != null ? this.usageRecord.toBuilder() : null;
        }

        @Override
        public final Builder usageRecord(UsageRecord usageRecord) {
            this.usageRecord = usageRecord;
            return this;
        }

        public final void setUsageRecord(UsageRecord.BuilderImpl usageRecord) {
            this.usageRecord = usageRecord != null ? usageRecord.build() : null;
        }

        public final String getMeteringRecordId() {
            return this.meteringRecordId;
        }

        @Override
        public final Builder meteringRecordId(String meteringRecordId) {
            this.meteringRecordId = meteringRecordId;
            return this;
        }

        public final void setMeteringRecordId(String meteringRecordId) {
            this.meteringRecordId = meteringRecordId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UsageRecordResultStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public UsageRecordResult build() {
            return new UsageRecordResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageRecordResult> {
        public Builder usageRecord(UsageRecord var1);

        default public Builder usageRecord(Consumer<UsageRecord.Builder> usageRecord) {
            return this.usageRecord((UsageRecord)((UsageRecord.Builder)UsageRecord.builder().applyMutation(usageRecord)).build());
        }

        public Builder meteringRecordId(String var1);

        public Builder status(String var1);

        public Builder status(UsageRecordResultStatus var1);
    }
}

