/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacedeployment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The shape containing the requested deployment parameter name and secretString.
 * </p>
 * <note>
 * <p>
 * To support AWS CloudFormation dynamic references to this resource using Quick Launch, this value must match a
 * parameter defined in the CloudFormation templated provided to buyers.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentParameterInput implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentParameterInput.Builder, DeploymentParameterInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeploymentParameterInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SECRET_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretString").getter(getter(DeploymentParameterInput::secretString))
            .setter(setter(Builder::secretString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SECRET_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String secretString;

    private DeploymentParameterInput(BuilderImpl builder) {
        this.name = builder.name;
        this.secretString = builder.secretString;
    }

    /**
     * <p>
     * The desired name of the deployment parameter. This is the identifier on which deployment parameters are keyed for
     * a given buyer and product. If this name matches an existing deployment parameter, this request will update the
     * existing resource.
     * </p>
     * 
     * @return The desired name of the deployment parameter. This is the identifier on which deployment parameters are
     *         keyed for a given buyer and product. If this name matches an existing deployment parameter, this request
     *         will update the existing resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The text to encrypt and store in the secret.
     * </p>
     * 
     * @return The text to encrypt and store in the secret.
     */
    public final String secretString() {
        return secretString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(secretString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentParameterInput)) {
            return false;
        }
        DeploymentParameterInput other = (DeploymentParameterInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(secretString(), other.secretString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentParameterInput").add("Name", name())
                .add("SecretString", secretString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "secretString":
            return Optional.ofNullable(clazz.cast(secretString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("secretString", SECRET_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentParameterInput, T> g) {
        return obj -> g.apply((DeploymentParameterInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentParameterInput> {
        /**
         * <p>
         * The desired name of the deployment parameter. This is the identifier on which deployment parameters are keyed
         * for a given buyer and product. If this name matches an existing deployment parameter, this request will
         * update the existing resource.
         * </p>
         * 
         * @param name
         *        The desired name of the deployment parameter. This is the identifier on which deployment parameters
         *        are keyed for a given buyer and product. If this name matches an existing deployment parameter, this
         *        request will update the existing resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The text to encrypt and store in the secret.
         * </p>
         * 
         * @param secretString
         *        The text to encrypt and store in the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretString(String secretString);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String secretString;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentParameterInput model) {
            name(model.name);
            secretString(model.secretString);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSecretString() {
            return secretString;
        }

        public final void setSecretString(String secretString) {
            this.secretString = secretString;
        }

        @Override
        public final Builder secretString(String secretString) {
            this.secretString = secretString;
            return this;
        }

        @Override
        public DeploymentParameterInput build() {
            return new DeploymentParameterInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
