/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacedeployment;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.marketplacedeployment.model.AccessDeniedException;
import software.amazon.awssdk.services.marketplacedeployment.model.ConflictException;
import software.amazon.awssdk.services.marketplacedeployment.model.InternalServerException;
import software.amazon.awssdk.services.marketplacedeployment.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.MarketplaceDeploymentException;
import software.amazon.awssdk.services.marketplacedeployment.model.PutDeploymentParameterRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.PutDeploymentParameterResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.ResourceNotFoundException;
import software.amazon.awssdk.services.marketplacedeployment.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.marketplacedeployment.model.TagResourceRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.TagResourceResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.ThrottlingException;
import software.amazon.awssdk.services.marketplacedeployment.model.UntagResourceRequest;
import software.amazon.awssdk.services.marketplacedeployment.model.UntagResourceResponse;
import software.amazon.awssdk.services.marketplacedeployment.model.ValidationException;

/**
 * Service client for accessing AWS Marketplace Deployment Service. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The AWS Marketplace Deployment Service supports the Quick Launch experience, which is a deployment option for
 * software as a service (SaaS) products. Quick Launch simplifies and reduces the time, resources, and steps required to
 * configure, deploy, and launch a products. The AWS Marketplace Deployment Service provides sellers with a secure
 * method for passing deployment parameters, such as API keys and external IDs, to buyers during the Quick Launch
 * experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MarketplaceDeploymentClient extends AwsClient {
    String SERVICE_NAME = "aws-marketplace";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "deployment-marketplace";

    /**
     * <p>
     * Lists all tags that have been added to a deployment parameter resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MarketplaceDeploymentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags that have been added to a deployment parameter resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, MarketplaceDeploymentException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a deployment parameter and is targeted by <code>catalog</code> and <code>agreementId</code>.
     * </p>
     *
     * @param putDeploymentParameterRequest
     * @return Result of the PutDeploymentParameter operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ServiceQuotaExceededException
     *         The maximum number of requests per account has been exceeded.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.PutDeploymentParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/PutDeploymentParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDeploymentParameterResponse putDeploymentParameter(PutDeploymentParameterRequest putDeploymentParameterRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException,
            ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            MarketplaceDeploymentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a deployment parameter and is targeted by <code>catalog</code> and <code>agreementId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeploymentParameterRequest.Builder} avoiding the
     * need to create one manually via {@link PutDeploymentParameterRequest#builder()}
     * </p>
     *
     * @param putDeploymentParameterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.PutDeploymentParameterRequest.Builder}
     *        to create a request.
     * @return Result of the PutDeploymentParameter operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ServiceQuotaExceededException
     *         The maximum number of requests per account has been exceeded.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.PutDeploymentParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/PutDeploymentParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default PutDeploymentParameterResponse putDeploymentParameter(
            Consumer<PutDeploymentParameterRequest.Builder> putDeploymentParameterRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceDeploymentException {
        return putDeploymentParameter(PutDeploymentParameterRequest.builder().applyMutation(putDeploymentParameterRequest)
                .build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MarketplaceDeploymentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MarketplaceDeploymentException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, MarketplaceDeploymentException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.marketplacedeployment.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Too many requests.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource wasn't found.
     * @throws ConflictException
     *         The request configuration has conflicts. For details, see the accompanying error message.
     * @throws ValidationException
     *         An error occurred during validation.
     * @throws InternalServerException
     *         There was an internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MarketplaceDeploymentException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MarketplaceDeploymentClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/marketplace-deployment-2023-01-25/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ConflictException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, MarketplaceDeploymentException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link MarketplaceDeploymentClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MarketplaceDeploymentClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MarketplaceDeploymentClient}.
     */
    static MarketplaceDeploymentClientBuilder builder() {
        return new DefaultMarketplaceDeploymentClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MarketplaceDeploymentServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
