/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSetType {
    CUSTOMER_SUBSCRIBER_HOURLY_MONTHLY_SUBSCRIPTIONS("customer_subscriber_hourly_monthly_subscriptions"),
    CUSTOMER_SUBSCRIBER_ANNUAL_SUBSCRIPTIONS("customer_subscriber_annual_subscriptions"),
    DAILY_BUSINESS_USAGE_BY_INSTANCE_TYPE("daily_business_usage_by_instance_type"),
    DAILY_BUSINESS_FEES("daily_business_fees"),
    DAILY_BUSINESS_FREE_TRIAL_CONVERSIONS("daily_business_free_trial_conversions"),
    DAILY_BUSINESS_NEW_INSTANCES("daily_business_new_instances"),
    DAILY_BUSINESS_NEW_PRODUCT_SUBSCRIBERS("daily_business_new_product_subscribers"),
    DAILY_BUSINESS_CANCELED_PRODUCT_SUBSCRIBERS("daily_business_canceled_product_subscribers"),
    MONTHLY_REVENUE_BILLING_AND_REVENUE_DATA("monthly_revenue_billing_and_revenue_data"),
    MONTHLY_REVENUE_ANNUAL_SUBSCRIPTIONS("monthly_revenue_annual_subscriptions"),
    DISBURSED_AMOUNT_BY_PRODUCT("disbursed_amount_by_product"),
    DISBURSED_AMOUNT_BY_PRODUCT_WITH_UNCOLLECTED_FUNDS("disbursed_amount_by_product_with_uncollected_funds"),
    DISBURSED_AMOUNT_BY_INSTANCE_HOURS("disbursed_amount_by_instance_hours"),
    DISBURSED_AMOUNT_BY_CUSTOMER_GEO("disbursed_amount_by_customer_geo"),
    DISBURSED_AMOUNT_BY_AGE_OF_UNCOLLECTED_FUNDS("disbursed_amount_by_age_of_uncollected_funds"),
    DISBURSED_AMOUNT_BY_AGE_OF_DISBURSED_FUNDS("disbursed_amount_by_age_of_disbursed_funds"),
    CUSTOMER_PROFILE_BY_INDUSTRY("customer_profile_by_industry"),
    CUSTOMER_PROFILE_BY_REVENUE("customer_profile_by_revenue"),
    CUSTOMER_PROFILE_BY_GEOGRAPHY("customer_profile_by_geography"),
    SALES_COMPENSATION_BILLED_REVENUE("sales_compensation_billed_revenue"),
    US_SALES_AND_USE_TAX_RECORDS("us_sales_and_use_tax_records"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataSetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataSetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSetType> knownValues() {
        return Stream.of(DataSetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

