/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.CustomerDefinedValuesCopier;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.DataSetType;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.MarketplaceCommerceAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateDataSetRequest
extends MarketplaceCommerceAnalyticsRequest
implements ToCopyableBuilder<Builder, GenerateDataSetRequest> {
    private static final SdkField<String> DATA_SET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::dataSetTypeAsString)).setter(GenerateDataSetRequest.setter(Builder::dataSetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetType").build()}).build();
    private static final SdkField<Instant> DATA_SET_PUBLICATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::dataSetPublicationDate)).setter(GenerateDataSetRequest.setter(Builder::dataSetPublicationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetPublicationDate").build()}).build();
    private static final SdkField<String> ROLE_NAME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::roleNameArn)).setter(GenerateDataSetRequest.setter(Builder::roleNameArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleNameArn").build()}).build();
    private static final SdkField<String> DESTINATION_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::destinationS3BucketName)).setter(GenerateDataSetRequest.setter(Builder::destinationS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3BucketName").build()}).build();
    private static final SdkField<String> DESTINATION_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::destinationS3Prefix)).setter(GenerateDataSetRequest.setter(Builder::destinationS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Prefix").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::snsTopicArn)).setter(GenerateDataSetRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOMER_DEFINED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GenerateDataSetRequest.getter(GenerateDataSetRequest::customerDefinedValues)).setter(GenerateDataSetRequest.setter(Builder::customerDefinedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerDefinedValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_TYPE_FIELD, DATA_SET_PUBLICATION_DATE_FIELD, ROLE_NAME_ARN_FIELD, DESTINATION_S3_BUCKET_NAME_FIELD, DESTINATION_S3_PREFIX_FIELD, SNS_TOPIC_ARN_FIELD, CUSTOMER_DEFINED_VALUES_FIELD));
    private final String dataSetType;
    private final Instant dataSetPublicationDate;
    private final String roleNameArn;
    private final String destinationS3BucketName;
    private final String destinationS3Prefix;
    private final String snsTopicArn;
    private final Map<String, String> customerDefinedValues;

    private GenerateDataSetRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetType = builder.dataSetType;
        this.dataSetPublicationDate = builder.dataSetPublicationDate;
        this.roleNameArn = builder.roleNameArn;
        this.destinationS3BucketName = builder.destinationS3BucketName;
        this.destinationS3Prefix = builder.destinationS3Prefix;
        this.snsTopicArn = builder.snsTopicArn;
        this.customerDefinedValues = builder.customerDefinedValues;
    }

    public DataSetType dataSetType() {
        return DataSetType.fromValue(this.dataSetType);
    }

    public String dataSetTypeAsString() {
        return this.dataSetType;
    }

    public Instant dataSetPublicationDate() {
        return this.dataSetPublicationDate;
    }

    public String roleNameArn() {
        return this.roleNameArn;
    }

    public String destinationS3BucketName() {
        return this.destinationS3BucketName;
    }

    public String destinationS3Prefix() {
        return this.destinationS3Prefix;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public boolean hasCustomerDefinedValues() {
        return this.customerDefinedValues != null && !(this.customerDefinedValues instanceof SdkAutoConstructMap);
    }

    public Map<String, String> customerDefinedValues() {
        return this.customerDefinedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetPublicationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleNameArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerDefinedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataSetRequest)) {
            return false;
        }
        GenerateDataSetRequest other = (GenerateDataSetRequest)((Object)obj);
        return Objects.equals(this.dataSetTypeAsString(), other.dataSetTypeAsString()) && Objects.equals(this.dataSetPublicationDate(), other.dataSetPublicationDate()) && Objects.equals(this.roleNameArn(), other.roleNameArn()) && Objects.equals(this.destinationS3BucketName(), other.destinationS3BucketName()) && Objects.equals(this.destinationS3Prefix(), other.destinationS3Prefix()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.customerDefinedValues(), other.customerDefinedValues());
    }

    public String toString() {
        return ToString.builder((String)"GenerateDataSetRequest").add("DataSetType", (Object)this.dataSetTypeAsString()).add("DataSetPublicationDate", (Object)this.dataSetPublicationDate()).add("RoleNameArn", (Object)this.roleNameArn()).add("DestinationS3BucketName", (Object)this.destinationS3BucketName()).add("DestinationS3Prefix", (Object)this.destinationS3Prefix()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("CustomerDefinedValues", this.customerDefinedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSetType": {
                return Optional.ofNullable(clazz.cast(this.dataSetTypeAsString()));
            }
            case "dataSetPublicationDate": {
                return Optional.ofNullable(clazz.cast(this.dataSetPublicationDate()));
            }
            case "roleNameArn": {
                return Optional.ofNullable(clazz.cast(this.roleNameArn()));
            }
            case "destinationS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.destinationS3BucketName()));
            }
            case "destinationS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Prefix()));
            }
            case "snsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "customerDefinedValues": {
                return Optional.ofNullable(clazz.cast(this.customerDefinedValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateDataSetRequest, T> g) {
        return obj -> g.apply((GenerateDataSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCommerceAnalyticsRequest.BuilderImpl
    implements Builder {
        private String dataSetType;
        private Instant dataSetPublicationDate;
        private String roleNameArn;
        private String destinationS3BucketName;
        private String destinationS3Prefix;
        private String snsTopicArn;
        private Map<String, String> customerDefinedValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataSetRequest model) {
            super(model);
            this.dataSetType(model.dataSetType);
            this.dataSetPublicationDate(model.dataSetPublicationDate);
            this.roleNameArn(model.roleNameArn);
            this.destinationS3BucketName(model.destinationS3BucketName);
            this.destinationS3Prefix(model.destinationS3Prefix);
            this.snsTopicArn(model.snsTopicArn);
            this.customerDefinedValues(model.customerDefinedValues);
        }

        public final String getDataSetTypeAsString() {
            return this.dataSetType;
        }

        @Override
        public final Builder dataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
            return this;
        }

        @Override
        public final Builder dataSetType(DataSetType dataSetType) {
            this.dataSetType(dataSetType == null ? null : dataSetType.toString());
            return this;
        }

        public final void setDataSetType(String dataSetType) {
            this.dataSetType = dataSetType;
        }

        public final Instant getDataSetPublicationDate() {
            return this.dataSetPublicationDate;
        }

        @Override
        public final Builder dataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
            return this;
        }

        public final void setDataSetPublicationDate(Instant dataSetPublicationDate) {
            this.dataSetPublicationDate = dataSetPublicationDate;
        }

        public final String getRoleNameArn() {
            return this.roleNameArn;
        }

        @Override
        public final Builder roleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
            return this;
        }

        public final void setRoleNameArn(String roleNameArn) {
            this.roleNameArn = roleNameArn;
        }

        public final String getDestinationS3BucketName() {
            return this.destinationS3BucketName;
        }

        @Override
        public final Builder destinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
            return this;
        }

        public final void setDestinationS3BucketName(String destinationS3BucketName) {
            this.destinationS3BucketName = destinationS3BucketName;
        }

        public final String getDestinationS3Prefix() {
            return this.destinationS3Prefix;
        }

        @Override
        public final Builder destinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
            return this;
        }

        public final void setDestinationS3Prefix(String destinationS3Prefix) {
            this.destinationS3Prefix = destinationS3Prefix;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getCustomerDefinedValues() {
            return this.customerDefinedValues;
        }

        @Override
        public final Builder customerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
            return this;
        }

        public final void setCustomerDefinedValues(Map<String, String> customerDefinedValues) {
            this.customerDefinedValues = CustomerDefinedValuesCopier.copy(customerDefinedValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataSetRequest build() {
            return new GenerateDataSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceCommerceAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateDataSetRequest> {
        public Builder dataSetType(String var1);

        public Builder dataSetType(DataSetType var1);

        public Builder dataSetPublicationDate(Instant var1);

        public Builder roleNameArn(String var1);

        public Builder destinationS3BucketName(String var1);

        public Builder destinationS3Prefix(String var1);

        public Builder snsTopicArn(String var1);

        public Builder customerDefinedValues(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

