/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecommerceanalytics.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.marketplacecommerceanalytics.model.GenerateDataSetRequest;

@SdkInternalApi
public class GenerateDataSetRequestModelMarshaller {
    private static final MarshallingInfo<String> DATASETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSetType").build();
    private static final MarshallingInfo<Instant> DATASETPUBLICATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSetPublicationDate").build();
    private static final MarshallingInfo<String> ROLENAMEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleNameArn").build();
    private static final MarshallingInfo<String> DESTINATIONS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3BucketName").build();
    private static final MarshallingInfo<String> DESTINATIONS3PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationS3Prefix").build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snsTopicArn").build();
    private static final MarshallingInfo<Map> CUSTOMERDEFINEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerDefinedValues").build();
    private static final GenerateDataSetRequestModelMarshaller INSTANCE = new GenerateDataSetRequestModelMarshaller();

    public static GenerateDataSetRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GenerateDataSetRequest generateDataSetRequest, ProtocolMarshaller protocolMarshaller) {
        if (generateDataSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)generateDataSetRequest.dataSetType(), DATASETTYPE_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.dataSetPublicationDate(), DATASETPUBLICATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.roleNameArn(), ROLENAMEARN_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.destinationS3BucketName(), DESTINATIONS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.destinationS3Prefix(), DESTINATIONS3PREFIX_BINDING);
            protocolMarshaller.marshall((Object)generateDataSetRequest.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(generateDataSetRequest.customerDefinedValues(), CUSTOMERDEFINEDVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

