/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant;
import software.amazon.awssdk.services.managedblockchainquery.model.ConfirmationStatusFilter;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsSort;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTransactionsRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, ListTransactionsRequest> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("address").getter(ListTransactionsRequest.getter(ListTransactionsRequest::address)).setter(ListTransactionsRequest.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(ListTransactionsRequest.getter(ListTransactionsRequest::networkAsString)).setter(ListTransactionsRequest.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<BlockchainInstant> FROM_BLOCKCHAIN_INSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fromBlockchainInstant").getter(ListTransactionsRequest.getter(ListTransactionsRequest::fromBlockchainInstant)).setter(ListTransactionsRequest.setter(Builder::fromBlockchainInstant)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBlockchainInstant").build()}).build();
    private static final SdkField<BlockchainInstant> TO_BLOCKCHAIN_INSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toBlockchainInstant").getter(ListTransactionsRequest.getter(ListTransactionsRequest::toBlockchainInstant)).setter(ListTransactionsRequest.setter(Builder::toBlockchainInstant)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toBlockchainInstant").build()}).build();
    private static final SdkField<ListTransactionsSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sort").getter(ListTransactionsRequest.getter(ListTransactionsRequest::sort)).setter(ListTransactionsRequest.setter(Builder::sort)).constructor(ListTransactionsSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTransactionsRequest.getter(ListTransactionsRequest::nextToken)).setter(ListTransactionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTransactionsRequest.getter(ListTransactionsRequest::maxResults)).setter(ListTransactionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<ConfirmationStatusFilter> CONFIRMATION_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("confirmationStatusFilter").getter(ListTransactionsRequest.getter(ListTransactionsRequest::confirmationStatusFilter)).setter(ListTransactionsRequest.setter(Builder::confirmationStatusFilter)).constructor(ConfirmationStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatusFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, NETWORK_FIELD, FROM_BLOCKCHAIN_INSTANT_FIELD, TO_BLOCKCHAIN_INSTANT_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONFIRMATION_STATUS_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTransactionsRequest.memberNameToFieldInitializer();
    private final String address;
    private final String network;
    private final BlockchainInstant fromBlockchainInstant;
    private final BlockchainInstant toBlockchainInstant;
    private final ListTransactionsSort sort;
    private final String nextToken;
    private final Integer maxResults;
    private final ConfirmationStatusFilter confirmationStatusFilter;

    private ListTransactionsRequest(BuilderImpl builder) {
        super(builder);
        this.address = builder.address;
        this.network = builder.network;
        this.fromBlockchainInstant = builder.fromBlockchainInstant;
        this.toBlockchainInstant = builder.toBlockchainInstant;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.confirmationStatusFilter = builder.confirmationStatusFilter;
    }

    public final String address() {
        return this.address;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final BlockchainInstant fromBlockchainInstant() {
        return this.fromBlockchainInstant;
    }

    public final BlockchainInstant toBlockchainInstant() {
        return this.toBlockchainInstant;
    }

    public final ListTransactionsSort sort() {
        return this.sort;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ConfirmationStatusFilter confirmationStatusFilter() {
        return this.confirmationStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(this.toBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStatusFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsRequest)) {
            return false;
        }
        ListTransactionsRequest other = (ListTransactionsRequest)((Object)obj);
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.fromBlockchainInstant(), other.fromBlockchainInstant()) && Objects.equals(this.toBlockchainInstant(), other.toBlockchainInstant()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.confirmationStatusFilter(), other.confirmationStatusFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListTransactionsRequest").add("Address", (Object)this.address()).add("Network", (Object)this.networkAsString()).add("FromBlockchainInstant", (Object)this.fromBlockchainInstant()).add("ToBlockchainInstant", (Object)this.toBlockchainInstant()).add("Sort", (Object)this.sort()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ConfirmationStatusFilter", (Object)this.confirmationStatusFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "fromBlockchainInstant": {
                return Optional.ofNullable(clazz.cast(this.fromBlockchainInstant()));
            }
            case "toBlockchainInstant": {
                return Optional.ofNullable(clazz.cast(this.toBlockchainInstant()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "confirmationStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.confirmationStatusFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("address", ADDRESS_FIELD);
        map.put("network", NETWORK_FIELD);
        map.put("fromBlockchainInstant", FROM_BLOCKCHAIN_INSTANT_FIELD);
        map.put("toBlockchainInstant", TO_BLOCKCHAIN_INSTANT_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("confirmationStatusFilter", CONFIRMATION_STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionsRequest, T> g) {
        return obj -> g.apply((ListTransactionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private String address;
        private String network;
        private BlockchainInstant fromBlockchainInstant;
        private BlockchainInstant toBlockchainInstant;
        private ListTransactionsSort sort;
        private String nextToken;
        private Integer maxResults;
        private ConfirmationStatusFilter confirmationStatusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionsRequest model) {
            super(model);
            this.address(model.address);
            this.network(model.network);
            this.fromBlockchainInstant(model.fromBlockchainInstant);
            this.toBlockchainInstant(model.toBlockchainInstant);
            this.sort(model.sort);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.confirmationStatusFilter(model.confirmationStatusFilter);
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final BlockchainInstant.Builder getFromBlockchainInstant() {
            return this.fromBlockchainInstant != null ? this.fromBlockchainInstant.toBuilder() : null;
        }

        public final void setFromBlockchainInstant(BlockchainInstant.BuilderImpl fromBlockchainInstant) {
            this.fromBlockchainInstant = fromBlockchainInstant != null ? fromBlockchainInstant.build() : null;
        }

        @Override
        public final Builder fromBlockchainInstant(BlockchainInstant fromBlockchainInstant) {
            this.fromBlockchainInstant = fromBlockchainInstant;
            return this;
        }

        public final BlockchainInstant.Builder getToBlockchainInstant() {
            return this.toBlockchainInstant != null ? this.toBlockchainInstant.toBuilder() : null;
        }

        public final void setToBlockchainInstant(BlockchainInstant.BuilderImpl toBlockchainInstant) {
            this.toBlockchainInstant = toBlockchainInstant != null ? toBlockchainInstant.build() : null;
        }

        @Override
        public final Builder toBlockchainInstant(BlockchainInstant toBlockchainInstant) {
            this.toBlockchainInstant = toBlockchainInstant;
            return this;
        }

        public final ListTransactionsSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(ListTransactionsSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListTransactionsSort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ConfirmationStatusFilter.Builder getConfirmationStatusFilter() {
            return this.confirmationStatusFilter != null ? this.confirmationStatusFilter.toBuilder() : null;
        }

        public final void setConfirmationStatusFilter(ConfirmationStatusFilter.BuilderImpl confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter != null ? confirmationStatusFilter.build() : null;
        }

        @Override
        public final Builder confirmationStatusFilter(ConfirmationStatusFilter confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTransactionsRequest build() {
            return new ListTransactionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTransactionsRequest> {
        public Builder address(String var1);

        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder fromBlockchainInstant(BlockchainInstant var1);

        default public Builder fromBlockchainInstant(Consumer<BlockchainInstant.Builder> fromBlockchainInstant) {
            return this.fromBlockchainInstant((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(fromBlockchainInstant)).build());
        }

        public Builder toBlockchainInstant(BlockchainInstant var1);

        default public Builder toBlockchainInstant(Consumer<BlockchainInstant.Builder> toBlockchainInstant) {
            return this.toBlockchainInstant((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(toBlockchainInstant)).build());
        }

        public Builder sort(ListTransactionsSort var1);

        default public Builder sort(Consumer<ListTransactionsSort.Builder> sort) {
            return this.sort((ListTransactionsSort)((ListTransactionsSort.Builder)ListTransactionsSort.builder().applyMutation(sort)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder confirmationStatusFilter(ConfirmationStatusFilter var1);

        default public Builder confirmationStatusFilter(Consumer<ConfirmationStatusFilter.Builder> confirmationStatusFilter) {
            return this.confirmationStatusFilter((ConfirmationStatusFilter)((ConfirmationStatusFilter.Builder)ConfirmationStatusFilter.builder().applyMutation(confirmationStatusFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

