/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of the contract.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContractMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ContractMetadata.Builder, ContractMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContractMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SYMBOL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("symbol")
            .getter(getter(ContractMetadata::symbol)).setter(setter(Builder::symbol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("symbol").build()).build();

    private static final SdkField<Integer> DECIMALS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("decimals").getter(getter(ContractMetadata::decimals)).setter(setter(Builder::decimals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SYMBOL_FIELD,
            DECIMALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String symbol;

    private final Integer decimals;

    private ContractMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.symbol = builder.symbol;
        this.decimals = builder.decimals;
    }

    /**
     * <p>
     * The name of the token contract.
     * </p>
     * 
     * @return The name of the token contract.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The symbol of the token contract.
     * </p>
     * 
     * @return The symbol of the token contract.
     */
    public final String symbol() {
        return symbol;
    }

    /**
     * <p>
     * The decimals used by the token contract.
     * </p>
     * 
     * @return The decimals used by the token contract.
     */
    public final Integer decimals() {
        return decimals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(symbol());
        hashCode = 31 * hashCode + Objects.hashCode(decimals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContractMetadata)) {
            return false;
        }
        ContractMetadata other = (ContractMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(symbol(), other.symbol())
                && Objects.equals(decimals(), other.decimals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContractMetadata").add("Name", name()).add("Symbol", symbol()).add("Decimals", decimals())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "symbol":
            return Optional.ofNullable(clazz.cast(symbol()));
        case "decimals":
            return Optional.ofNullable(clazz.cast(decimals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("symbol", SYMBOL_FIELD);
        map.put("decimals", DECIMALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContractMetadata, T> g) {
        return obj -> g.apply((ContractMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContractMetadata> {
        /**
         * <p>
         * The name of the token contract.
         * </p>
         * 
         * @param name
         *        The name of the token contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The symbol of the token contract.
         * </p>
         * 
         * @param symbol
         *        The symbol of the token contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder symbol(String symbol);

        /**
         * <p>
         * The decimals used by the token contract.
         * </p>
         * 
         * @param decimals
         *        The decimals used by the token contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimals(Integer decimals);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String symbol;

        private Integer decimals;

        private BuilderImpl() {
        }

        private BuilderImpl(ContractMetadata model) {
            name(model.name);
            symbol(model.symbol);
            decimals(model.decimals);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSymbol() {
            return symbol;
        }

        public final void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @Override
        public final Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public final Integer getDecimals() {
            return decimals;
        }

        public final void setDecimals(Integer decimals) {
            this.decimals = decimals;
        }

        @Override
        public final Builder decimals(Integer decimals) {
            this.decimals = decimals;
            return this;
        }

        @Override
        public ContractMetadata build() {
            return new ContractMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
