/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier;
import software.amazon.awssdk.services.managedblockchainquery.model.ContractMetadata;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetContractResponse
extends ManagedBlockchainQueryResponse
implements ToCopyableBuilder<Builder, GetAssetContractResponse> {
    private static final SdkField<ContractIdentifier> CONTRACT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contractIdentifier").getter(GetAssetContractResponse.getter(GetAssetContractResponse::contractIdentifier)).setter(GetAssetContractResponse.setter(Builder::contractIdentifier)).constructor(ContractIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractIdentifier").build()}).build();
    private static final SdkField<String> TOKEN_STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenStandard").getter(GetAssetContractResponse.getter(GetAssetContractResponse::tokenStandardAsString)).setter(GetAssetContractResponse.setter(Builder::tokenStandard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenStandard").build()}).build();
    private static final SdkField<String> DEPLOYER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deployerAddress").getter(GetAssetContractResponse.getter(GetAssetContractResponse::deployerAddress)).setter(GetAssetContractResponse.setter(Builder::deployerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployerAddress").build()}).build();
    private static final SdkField<ContractMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GetAssetContractResponse.getter(GetAssetContractResponse::metadata)).setter(GetAssetContractResponse.setter(Builder::metadata)).constructor(ContractMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACT_IDENTIFIER_FIELD, TOKEN_STANDARD_FIELD, DEPLOYER_ADDRESS_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssetContractResponse.memberNameToFieldInitializer();
    private final ContractIdentifier contractIdentifier;
    private final String tokenStandard;
    private final String deployerAddress;
    private final ContractMetadata metadata;

    private GetAssetContractResponse(BuilderImpl builder) {
        super(builder);
        this.contractIdentifier = builder.contractIdentifier;
        this.tokenStandard = builder.tokenStandard;
        this.deployerAddress = builder.deployerAddress;
        this.metadata = builder.metadata;
    }

    public final ContractIdentifier contractIdentifier() {
        return this.contractIdentifier;
    }

    public final QueryTokenStandard tokenStandard() {
        return QueryTokenStandard.fromValue(this.tokenStandard);
    }

    public final String tokenStandardAsString() {
        return this.tokenStandard;
    }

    public final String deployerAddress() {
        return this.deployerAddress;
    }

    public final ContractMetadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contractIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetContractResponse)) {
            return false;
        }
        GetAssetContractResponse other = (GetAssetContractResponse)((Object)obj);
        return Objects.equals(this.contractIdentifier(), other.contractIdentifier()) && Objects.equals(this.tokenStandardAsString(), other.tokenStandardAsString()) && Objects.equals(this.deployerAddress(), other.deployerAddress()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetContractResponse").add("ContractIdentifier", (Object)this.contractIdentifier()).add("TokenStandard", (Object)this.tokenStandardAsString()).add("DeployerAddress", (Object)this.deployerAddress()).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contractIdentifier": {
                return Optional.ofNullable(clazz.cast(this.contractIdentifier()));
            }
            case "tokenStandard": {
                return Optional.ofNullable(clazz.cast(this.tokenStandardAsString()));
            }
            case "deployerAddress": {
                return Optional.ofNullable(clazz.cast(this.deployerAddress()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractIdentifier", CONTRACT_IDENTIFIER_FIELD);
        map.put("tokenStandard", TOKEN_STANDARD_FIELD);
        map.put("deployerAddress", DEPLOYER_ADDRESS_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssetContractResponse, T> g) {
        return obj -> g.apply((GetAssetContractResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryResponse.BuilderImpl
    implements Builder {
        private ContractIdentifier contractIdentifier;
        private String tokenStandard;
        private String deployerAddress;
        private ContractMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetContractResponse model) {
            super(model);
            this.contractIdentifier(model.contractIdentifier);
            this.tokenStandard(model.tokenStandard);
            this.deployerAddress(model.deployerAddress);
            this.metadata(model.metadata);
        }

        public final ContractIdentifier.Builder getContractIdentifier() {
            return this.contractIdentifier != null ? this.contractIdentifier.toBuilder() : null;
        }

        public final void setContractIdentifier(ContractIdentifier.BuilderImpl contractIdentifier) {
            this.contractIdentifier = contractIdentifier != null ? contractIdentifier.build() : null;
        }

        @Override
        public final Builder contractIdentifier(ContractIdentifier contractIdentifier) {
            this.contractIdentifier = contractIdentifier;
            return this;
        }

        public final String getTokenStandard() {
            return this.tokenStandard;
        }

        public final void setTokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
        }

        @Override
        public final Builder tokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
            return this;
        }

        @Override
        public final Builder tokenStandard(QueryTokenStandard tokenStandard) {
            this.tokenStandard(tokenStandard == null ? null : tokenStandard.toString());
            return this;
        }

        public final String getDeployerAddress() {
            return this.deployerAddress;
        }

        public final void setDeployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
        }

        @Override
        public final Builder deployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
            return this;
        }

        public final ContractMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ContractMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ContractMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetAssetContractResponse build() {
            return new GetAssetContractResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetContractResponse> {
        public Builder contractIdentifier(ContractIdentifier var1);

        default public Builder contractIdentifier(Consumer<ContractIdentifier.Builder> contractIdentifier) {
            return this.contractIdentifier((ContractIdentifier)((ContractIdentifier.Builder)ContractIdentifier.builder().applyMutation(contractIdentifier)).build());
        }

        public Builder tokenStandard(String var1);

        public Builder tokenStandard(QueryTokenStandard var1);

        public Builder deployerAddress(String var1);

        public Builder metadata(ContractMetadata var1);

        default public Builder metadata(Consumer<ContractMetadata.Builder> metadata) {
            return this.metadata((ContractMetadata)((ContractMetadata.Builder)ContractMetadata.builder().applyMutation(metadata)).build());
        }
    }
}

