/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance;

public class ListTokenBalancesIterable
implements SdkIterable<ListTokenBalancesResponse> {
    private final ManagedBlockchainQueryClient client;
    private final ListTokenBalancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTokenBalancesIterable(ManagedBlockchainQueryClient client, ListTokenBalancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTokenBalancesResponseFetcher();
    }

    public Iterator<ListTokenBalancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TokenBalance> tokenBalances() {
        Function<ListTokenBalancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tokenBalances() != null) {
                return response.tokenBalances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTokenBalancesResponseFetcher
    implements SyncPageFetcher<ListTokenBalancesResponse> {
        private ListTokenBalancesResponseFetcher() {
        }

        public boolean hasNextPage(ListTokenBalancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTokenBalancesResponse nextPage(ListTokenBalancesResponse previousPage) {
            if (previousPage == null) {
                return ListTokenBalancesIterable.this.client.listTokenBalances(ListTokenBalancesIterable.this.firstRequest);
            }
            return ListTokenBalancesIterable.this.client.listTokenBalances((ListTokenBalancesRequest)((Object)ListTokenBalancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

