/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryAsyncClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListFilteredTransactionEventsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListFilteredTransactionEventsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TransactionEvent;

public class ListFilteredTransactionEventsPublisher
implements SdkPublisher<ListFilteredTransactionEventsResponse> {
    private final ManagedBlockchainQueryAsyncClient client;
    private final ListFilteredTransactionEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFilteredTransactionEventsPublisher(ManagedBlockchainQueryAsyncClient client, ListFilteredTransactionEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFilteredTransactionEventsPublisher(ManagedBlockchainQueryAsyncClient client, ListFilteredTransactionEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFilteredTransactionEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFilteredTransactionEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransactionEvent> events() {
        Function<ListFilteredTransactionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFilteredTransactionEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFilteredTransactionEventsResponseFetcher
    implements AsyncPageFetcher<ListFilteredTransactionEventsResponse> {
        private ListFilteredTransactionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListFilteredTransactionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFilteredTransactionEventsResponse> nextPage(ListFilteredTransactionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListFilteredTransactionEventsPublisher.this.client.listFilteredTransactionEvents(ListFilteredTransactionEventsPublisher.this.firstRequest);
            }
            return ListFilteredTransactionEventsPublisher.this.client.listFilteredTransactionEvents((ListFilteredTransactionEventsRequest)((Object)ListFilteredTransactionEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

