/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier;
import software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTokenBalanceRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, GetTokenBalanceRequest> {
    private static final SdkField<TokenIdentifier> TOKEN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenIdentifier").getter(GetTokenBalanceRequest.getter(GetTokenBalanceRequest::tokenIdentifier)).setter(GetTokenBalanceRequest.setter(Builder::tokenIdentifier)).constructor(TokenIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenIdentifier").build()}).build();
    private static final SdkField<OwnerIdentifier> OWNER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ownerIdentifier").getter(GetTokenBalanceRequest.getter(GetTokenBalanceRequest::ownerIdentifier)).setter(GetTokenBalanceRequest.setter(Builder::ownerIdentifier)).constructor(OwnerIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerIdentifier").build()}).build();
    private static final SdkField<BlockchainInstant> AT_BLOCKCHAIN_INSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("atBlockchainInstant").getter(GetTokenBalanceRequest.getter(GetTokenBalanceRequest::atBlockchainInstant)).setter(GetTokenBalanceRequest.setter(Builder::atBlockchainInstant)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atBlockchainInstant").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_IDENTIFIER_FIELD, OWNER_IDENTIFIER_FIELD, AT_BLOCKCHAIN_INSTANT_FIELD));
    private final TokenIdentifier tokenIdentifier;
    private final OwnerIdentifier ownerIdentifier;
    private final BlockchainInstant atBlockchainInstant;

    private GetTokenBalanceRequest(BuilderImpl builder) {
        super(builder);
        this.tokenIdentifier = builder.tokenIdentifier;
        this.ownerIdentifier = builder.ownerIdentifier;
        this.atBlockchainInstant = builder.atBlockchainInstant;
    }

    public final TokenIdentifier tokenIdentifier() {
        return this.tokenIdentifier;
    }

    public final OwnerIdentifier ownerIdentifier() {
        return this.ownerIdentifier;
    }

    public final BlockchainInstant atBlockchainInstant() {
        return this.atBlockchainInstant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.atBlockchainInstant());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTokenBalanceRequest)) {
            return false;
        }
        GetTokenBalanceRequest other = (GetTokenBalanceRequest)((Object)obj);
        return Objects.equals(this.tokenIdentifier(), other.tokenIdentifier()) && Objects.equals(this.ownerIdentifier(), other.ownerIdentifier()) && Objects.equals(this.atBlockchainInstant(), other.atBlockchainInstant());
    }

    public final String toString() {
        return ToString.builder((String)"GetTokenBalanceRequest").add("TokenIdentifier", (Object)this.tokenIdentifier()).add("OwnerIdentifier", (Object)this.ownerIdentifier()).add("AtBlockchainInstant", (Object)this.atBlockchainInstant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenIdentifier": {
                return Optional.ofNullable(clazz.cast(this.tokenIdentifier()));
            }
            case "ownerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ownerIdentifier()));
            }
            case "atBlockchainInstant": {
                return Optional.ofNullable(clazz.cast(this.atBlockchainInstant()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTokenBalanceRequest, T> g) {
        return obj -> g.apply((GetTokenBalanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private TokenIdentifier tokenIdentifier;
        private OwnerIdentifier ownerIdentifier;
        private BlockchainInstant atBlockchainInstant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTokenBalanceRequest model) {
            super(model);
            this.tokenIdentifier(model.tokenIdentifier);
            this.ownerIdentifier(model.ownerIdentifier);
            this.atBlockchainInstant(model.atBlockchainInstant);
        }

        public final TokenIdentifier.Builder getTokenIdentifier() {
            return this.tokenIdentifier != null ? this.tokenIdentifier.toBuilder() : null;
        }

        public final void setTokenIdentifier(TokenIdentifier.BuilderImpl tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier != null ? tokenIdentifier.build() : null;
        }

        @Override
        public final Builder tokenIdentifier(TokenIdentifier tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public final OwnerIdentifier.Builder getOwnerIdentifier() {
            return this.ownerIdentifier != null ? this.ownerIdentifier.toBuilder() : null;
        }

        public final void setOwnerIdentifier(OwnerIdentifier.BuilderImpl ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier != null ? ownerIdentifier.build() : null;
        }

        @Override
        public final Builder ownerIdentifier(OwnerIdentifier ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier;
            return this;
        }

        public final BlockchainInstant.Builder getAtBlockchainInstant() {
            return this.atBlockchainInstant != null ? this.atBlockchainInstant.toBuilder() : null;
        }

        public final void setAtBlockchainInstant(BlockchainInstant.BuilderImpl atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant != null ? atBlockchainInstant.build() : null;
        }

        @Override
        public final Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTokenBalanceRequest build() {
            return new GetTokenBalanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTokenBalanceRequest> {
        public Builder tokenIdentifier(TokenIdentifier var1);

        default public Builder tokenIdentifier(Consumer<TokenIdentifier.Builder> tokenIdentifier) {
            return this.tokenIdentifier((TokenIdentifier)((TokenIdentifier.Builder)TokenIdentifier.builder().applyMutation(tokenIdentifier)).build());
        }

        public Builder ownerIdentifier(OwnerIdentifier var1);

        default public Builder ownerIdentifier(Consumer<OwnerIdentifier.Builder> ownerIdentifier) {
            return this.ownerIdentifier((OwnerIdentifier)((OwnerIdentifier.Builder)OwnerIdentifier.builder().applyMutation(ownerIdentifier)).build());
        }

        public Builder atBlockchainInstant(BlockchainInstant var1);

        default public Builder atBlockchainInstant(Consumer<BlockchainInstant.Builder> atBlockchainInstant) {
            return this.atBlockchainInstant((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(atBlockchainInstant)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

