/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetContractRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, GetAssetContractRequest> {
    private static final SdkField<ContractIdentifier> CONTRACT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contractIdentifier").getter(GetAssetContractRequest.getter(GetAssetContractRequest::contractIdentifier)).setter(GetAssetContractRequest.setter(Builder::contractIdentifier)).constructor(ContractIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACT_IDENTIFIER_FIELD));
    private final ContractIdentifier contractIdentifier;

    private GetAssetContractRequest(BuilderImpl builder) {
        super(builder);
        this.contractIdentifier = builder.contractIdentifier;
    }

    public final ContractIdentifier contractIdentifier() {
        return this.contractIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contractIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetContractRequest)) {
            return false;
        }
        GetAssetContractRequest other = (GetAssetContractRequest)((Object)obj);
        return Objects.equals(this.contractIdentifier(), other.contractIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetContractRequest").add("ContractIdentifier", (Object)this.contractIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contractIdentifier": {
                return Optional.ofNullable(clazz.cast(this.contractIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssetContractRequest, T> g) {
        return obj -> g.apply((GetAssetContractRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private ContractIdentifier contractIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetContractRequest model) {
            super(model);
            this.contractIdentifier(model.contractIdentifier);
        }

        public final ContractIdentifier.Builder getContractIdentifier() {
            return this.contractIdentifier != null ? this.contractIdentifier.toBuilder() : null;
        }

        public final void setContractIdentifier(ContractIdentifier.BuilderImpl contractIdentifier) {
            this.contractIdentifier = contractIdentifier != null ? contractIdentifier.build() : null;
        }

        @Override
        public final Builder contractIdentifier(ContractIdentifier contractIdentifier) {
            this.contractIdentifier = contractIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssetContractRequest build() {
            return new GetAssetContractRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetContractRequest> {
        public Builder contractIdentifier(ContractIdentifier var1);

        default public Builder contractIdentifier(Consumer<ContractIdentifier.Builder> contractIdentifier) {
            return this.contractIdentifier((ContractIdentifier)((ContractIdentifier.Builder)ContractIdentifier.builder().applyMutation(contractIdentifier)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

