/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContractFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContractFilter> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(ContractFilter.getter(ContractFilter::networkAsString)).setter(ContractFilter.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<String> TOKEN_STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenStandard").getter(ContractFilter.getter(ContractFilter::tokenStandardAsString)).setter(ContractFilter.setter(Builder::tokenStandard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenStandard").build()}).build();
    private static final SdkField<String> DEPLOYER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deployerAddress").getter(ContractFilter.getter(ContractFilter::deployerAddress)).setter(ContractFilter.setter(Builder::deployerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployerAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD, TOKEN_STANDARD_FIELD, DEPLOYER_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String network;
    private final String tokenStandard;
    private final String deployerAddress;

    private ContractFilter(BuilderImpl builder) {
        this.network = builder.network;
        this.tokenStandard = builder.tokenStandard;
        this.deployerAddress = builder.deployerAddress;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final QueryTokenStandard tokenStandard() {
        return QueryTokenStandard.fromValue(this.tokenStandard);
    }

    public final String tokenStandardAsString() {
        return this.tokenStandard;
    }

    public final String deployerAddress() {
        return this.deployerAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployerAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContractFilter)) {
            return false;
        }
        ContractFilter other = (ContractFilter)obj;
        return Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.tokenStandardAsString(), other.tokenStandardAsString()) && Objects.equals(this.deployerAddress(), other.deployerAddress());
    }

    public final String toString() {
        return ToString.builder((String)"ContractFilter").add("Network", (Object)this.networkAsString()).add("TokenStandard", (Object)this.tokenStandardAsString()).add("DeployerAddress", (Object)this.deployerAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "tokenStandard": {
                return Optional.ofNullable(clazz.cast(this.tokenStandardAsString()));
            }
            case "deployerAddress": {
                return Optional.ofNullable(clazz.cast(this.deployerAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContractFilter, T> g) {
        return obj -> g.apply((ContractFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String network;
        private String tokenStandard;
        private String deployerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ContractFilter model) {
            this.network(model.network);
            this.tokenStandard(model.tokenStandard);
            this.deployerAddress(model.deployerAddress);
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getTokenStandard() {
            return this.tokenStandard;
        }

        public final void setTokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
        }

        @Override
        public final Builder tokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
            return this;
        }

        @Override
        public final Builder tokenStandard(QueryTokenStandard tokenStandard) {
            this.tokenStandard(tokenStandard == null ? null : tokenStandard.toString());
            return this;
        }

        public final String getDeployerAddress() {
            return this.deployerAddress;
        }

        public final void setDeployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
        }

        @Override
        public final Builder deployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
            return this;
        }

        public ContractFilter build() {
            return new ContractFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContractFilter> {
        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder tokenStandard(String var1);

        public Builder tokenStandard(QueryTokenStandard var1);

        public Builder deployerAddress(String var1);
    }
}

