/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.Framework;
import software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkAttributes;
import software.amazon.awssdk.services.managedblockchain.model.NetworkStatus;
import software.amazon.awssdk.services.managedblockchain.model.VotingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Network
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Network> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::id)).setter(Network.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::name)).setter(Network.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::description)).setter(Network.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::frameworkAsString)).setter(Network.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::frameworkVersion)).setter(Network.setter(Builder::frameworkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()}).build();
    private static final SdkField<NetworkFrameworkAttributes> FRAMEWORK_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Network.getter(Network::frameworkAttributes)).setter(Network.setter(Builder::frameworkAttributes)).constructor(NetworkFrameworkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkAttributes").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::vpcEndpointServiceName)).setter(Network.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointServiceName").build()}).build();
    private static final SdkField<VotingPolicy> VOTING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Network.getter(Network::votingPolicy)).setter(Network.setter(Builder::votingPolicy)).constructor(VotingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VotingPolicy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::statusAsString)).setter(Network.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Network.getter(Network::creationDate)).setter(Network.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, FRAMEWORK_ATTRIBUTES_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD, VOTING_POLICY_FIELD, STATUS_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String framework;
    private final String frameworkVersion;
    private final NetworkFrameworkAttributes frameworkAttributes;
    private final String vpcEndpointServiceName;
    private final VotingPolicy votingPolicy;
    private final String status;
    private final Instant creationDate;

    private Network(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.frameworkAttributes = builder.frameworkAttributes;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.votingPolicy = builder.votingPolicy;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Framework framework() {
        return Framework.fromValue(this.framework);
    }

    public String frameworkAsString() {
        return this.framework;
    }

    public String frameworkVersion() {
        return this.frameworkVersion;
    }

    public NetworkFrameworkAttributes frameworkAttributes() {
        return this.frameworkAttributes;
    }

    public String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public VotingPolicy votingPolicy() {
        return this.votingPolicy;
    }

    public NetworkStatus status() {
        return NetworkStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.votingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.frameworkAsString(), other.frameworkAsString()) && Objects.equals(this.frameworkVersion(), other.frameworkVersion()) && Objects.equals(this.frameworkAttributes(), other.frameworkAttributes()) && Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName()) && Objects.equals(this.votingPolicy(), other.votingPolicy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"Network").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Framework", (Object)this.frameworkAsString()).add("FrameworkVersion", (Object)this.frameworkVersion()).add("FrameworkAttributes", (Object)this.frameworkAttributes()).add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).add("VotingPolicy", (Object)this.votingPolicy()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.frameworkAsString()));
            }
            case "FrameworkVersion": {
                return Optional.ofNullable(clazz.cast(this.frameworkVersion()));
            }
            case "FrameworkAttributes": {
                return Optional.ofNullable(clazz.cast(this.frameworkAttributes()));
            }
            case "VpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
            case "VotingPolicy": {
                return Optional.ofNullable(clazz.cast(this.votingPolicy()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String framework;
        private String frameworkVersion;
        private NetworkFrameworkAttributes frameworkAttributes;
        private String vpcEndpointServiceName;
        private VotingPolicy votingPolicy;
        private String status;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.framework(model.framework);
            this.frameworkVersion(model.frameworkVersion);
            this.frameworkAttributes(model.frameworkAttributes);
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
            this.votingPolicy(model.votingPolicy);
            this.status(model.status);
            this.creationDate(model.creationDate);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFrameworkAsString() {
            return this.framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework.toString());
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final String getFrameworkVersion() {
            return this.frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        public final NetworkFrameworkAttributes.Builder getFrameworkAttributes() {
            return this.frameworkAttributes != null ? this.frameworkAttributes.toBuilder() : null;
        }

        @Override
        public final Builder frameworkAttributes(NetworkFrameworkAttributes frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes;
            return this;
        }

        public final void setFrameworkAttributes(NetworkFrameworkAttributes.BuilderImpl frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes != null ? frameworkAttributes.build() : null;
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        public final VotingPolicy.Builder getVotingPolicy() {
            return this.votingPolicy != null ? this.votingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder votingPolicy(VotingPolicy votingPolicy) {
            this.votingPolicy = votingPolicy;
            return this;
        }

        public final void setVotingPolicy(VotingPolicy.BuilderImpl votingPolicy) {
            this.votingPolicy = votingPolicy != null ? votingPolicy.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public Network build() {
            return new Network(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Network> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder framework(String var1);

        public Builder framework(Framework var1);

        public Builder frameworkVersion(String var1);

        public Builder frameworkAttributes(NetworkFrameworkAttributes var1);

        default public Builder frameworkAttributes(Consumer<NetworkFrameworkAttributes.Builder> frameworkAttributes) {
            return this.frameworkAttributes((NetworkFrameworkAttributes)((NetworkFrameworkAttributes.Builder)NetworkFrameworkAttributes.builder().applyMutation(frameworkAttributes)).build());
        }

        public Builder vpcEndpointServiceName(String var1);

        public Builder votingPolicy(VotingPolicy var1);

        default public Builder votingPolicy(Consumer<VotingPolicy.Builder> votingPolicy) {
            return this.votingPolicy((VotingPolicy)((VotingPolicy.Builder)VotingPolicy.builder().applyMutation(votingPolicy)).build());
        }

        public Builder status(String var1);

        public Builder status(NetworkStatus var1);

        public Builder creationDate(Instant var1);
    }
}

