/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainResponse;
import software.amazon.awssdk.services.managedblockchain.model.NetworkSummary;
import software.amazon.awssdk.services.managedblockchain.model.NetworkSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworksResponse
extends ManagedBlockchainResponse
implements ToCopyableBuilder<Builder, ListNetworksResponse> {
    private static final SdkField<List<NetworkSummary>> NETWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListNetworksResponse.getter(ListNetworksResponse::networks)).setter(ListNetworksResponse.setter(Builder::networks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Networks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNetworksResponse.getter(ListNetworksResponse::nextToken)).setter(ListNetworksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<NetworkSummary> networks;
    private final String nextToken;

    private ListNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.networks = builder.networks;
        this.nextToken = builder.nextToken;
    }

    public List<NetworkSummary> networks() {
        return this.networks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworksResponse)) {
            return false;
        }
        ListNetworksResponse other = (ListNetworksResponse)((Object)obj);
        return Objects.equals(this.networks(), other.networks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListNetworksResponse").add("Networks", this.networks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Networks": {
                return Optional.ofNullable(clazz.cast(this.networks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworksResponse, T> g) {
        return obj -> g.apply((ListNetworksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainResponse.BuilderImpl
    implements Builder {
        private List<NetworkSummary> networks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworksResponse model) {
            super(model);
            this.networks(model.networks);
            this.nextToken(model.nextToken);
        }

        public final Collection<NetworkSummary.Builder> getNetworks() {
            return this.networks != null ? (Collection)this.networks.stream().map(NetworkSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networks(Collection<NetworkSummary> networks) {
            this.networks = NetworkSummaryListCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(NetworkSummary ... networks) {
            this.networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<NetworkSummary.Builder> ... networks) {
            this.networks(Stream.of(networks).map(c -> (NetworkSummary)((NetworkSummary.Builder)NetworkSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworks(Collection<NetworkSummary.BuilderImpl> networks) {
            this.networks = NetworkSummaryListCopier.copyFromBuilder(networks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNetworksResponse build() {
            return new ListNetworksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworksResponse> {
        public Builder networks(Collection<NetworkSummary> var1);

        public Builder networks(NetworkSummary ... var1);

        public Builder networks(Consumer<NetworkSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

