/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainResponse;
import software.amazon.awssdk.services.managedblockchain.model.ProposalVoteListCopier;
import software.amazon.awssdk.services.managedblockchain.model.VoteSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProposalVotesResponse
extends ManagedBlockchainResponse
implements ToCopyableBuilder<Builder, ListProposalVotesResponse> {
    private static final SdkField<List<VoteSummary>> PROPOSAL_VOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProposalVotes").getter(ListProposalVotesResponse.getter(ListProposalVotesResponse::proposalVotes)).setter(ListProposalVotesResponse.setter(Builder::proposalVotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalVotes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoteSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProposalVotesResponse.getter(ListProposalVotesResponse::nextToken)).setter(ListProposalVotesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_VOTES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProposalVotesResponse.memberNameToFieldInitializer();
    private final List<VoteSummary> proposalVotes;
    private final String nextToken;

    private ListProposalVotesResponse(BuilderImpl builder) {
        super(builder);
        this.proposalVotes = builder.proposalVotes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProposalVotes() {
        return this.proposalVotes != null && !(this.proposalVotes instanceof SdkAutoConstructList);
    }

    public final List<VoteSummary> proposalVotes() {
        return this.proposalVotes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProposalVotes() ? this.proposalVotes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProposalVotesResponse)) {
            return false;
        }
        ListProposalVotesResponse other = (ListProposalVotesResponse)((Object)obj);
        return this.hasProposalVotes() == other.hasProposalVotes() && Objects.equals(this.proposalVotes(), other.proposalVotes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProposalVotesResponse").add("ProposalVotes", this.hasProposalVotes() ? this.proposalVotes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProposalVotes": {
                return Optional.ofNullable(clazz.cast(this.proposalVotes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProposalVotes", PROPOSAL_VOTES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProposalVotesResponse, T> g) {
        return obj -> g.apply((ListProposalVotesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainResponse.BuilderImpl
    implements Builder {
        private List<VoteSummary> proposalVotes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProposalVotesResponse model) {
            super(model);
            this.proposalVotes(model.proposalVotes);
            this.nextToken(model.nextToken);
        }

        public final List<VoteSummary.Builder> getProposalVotes() {
            List<VoteSummary.Builder> result = ProposalVoteListCopier.copyToBuilder(this.proposalVotes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProposalVotes(Collection<VoteSummary.BuilderImpl> proposalVotes) {
            this.proposalVotes = ProposalVoteListCopier.copyFromBuilder(proposalVotes);
        }

        @Override
        public final Builder proposalVotes(Collection<VoteSummary> proposalVotes) {
            this.proposalVotes = ProposalVoteListCopier.copy(proposalVotes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposalVotes(VoteSummary ... proposalVotes) {
            this.proposalVotes(Arrays.asList(proposalVotes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposalVotes(Consumer<VoteSummary.Builder> ... proposalVotes) {
            this.proposalVotes(Stream.of(proposalVotes).map(c -> (VoteSummary)((VoteSummary.Builder)VoteSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProposalVotesResponse build() {
            return new ListProposalVotesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ManagedBlockchainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProposalVotesResponse> {
        public Builder proposalVotes(Collection<VoteSummary> var1);

        public Builder proposalVotes(VoteSummary ... var1);

        public Builder proposalVotes(Consumer<VoteSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

