/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of an individual vote that a member cast for a proposal.
 * </p>
 * <p>
 * Applies only to Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoteSummary implements SdkPojo, Serializable, ToCopyableBuilder<VoteSummary.Builder, VoteSummary> {
    private static final SdkField<String> VOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Vote")
            .getter(getter(VoteSummary::voteAsString)).setter(setter(Builder::vote))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vote").build()).build();

    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberName").getter(getter(VoteSummary::memberName)).setter(setter(Builder::memberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberName").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(VoteSummary::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOTE_FIELD, MEMBER_NAME_FIELD,
            MEMBER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vote;

    private final String memberName;

    private final String memberId;

    private VoteSummary(BuilderImpl builder) {
        this.vote = builder.vote;
        this.memberName = builder.memberName;
        this.memberId = builder.memberId;
    }

    /**
     * <p>
     * The vote value, either <code>YES</code> or <code>NO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vote} will return
     * {@link VoteValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voteAsString}.
     * </p>
     * 
     * @return The vote value, either <code>YES</code> or <code>NO</code>.
     * @see VoteValue
     */
    public final VoteValue vote() {
        return VoteValue.fromValue(vote);
    }

    /**
     * <p>
     * The vote value, either <code>YES</code> or <code>NO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vote} will return
     * {@link VoteValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voteAsString}.
     * </p>
     * 
     * @return The vote value, either <code>YES</code> or <code>NO</code>.
     * @see VoteValue
     */
    public final String voteAsString() {
        return vote;
    }

    /**
     * <p>
     * The name of the member that cast the vote.
     * </p>
     * 
     * @return The name of the member that cast the vote.
     */
    public final String memberName() {
        return memberName;
    }

    /**
     * <p>
     * The unique identifier of the member that cast the vote.
     * </p>
     * 
     * @return The unique identifier of the member that cast the vote.
     */
    public final String memberId() {
        return memberId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voteAsString());
        hashCode = 31 * hashCode + Objects.hashCode(memberName());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoteSummary)) {
            return false;
        }
        VoteSummary other = (VoteSummary) obj;
        return Objects.equals(voteAsString(), other.voteAsString()) && Objects.equals(memberName(), other.memberName())
                && Objects.equals(memberId(), other.memberId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoteSummary").add("Vote", voteAsString()).add("MemberName", memberName())
                .add("MemberId", memberId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vote":
            return Optional.ofNullable(clazz.cast(voteAsString()));
        case "MemberName":
            return Optional.ofNullable(clazz.cast(memberName()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Vote", VOTE_FIELD);
        map.put("MemberName", MEMBER_NAME_FIELD);
        map.put("MemberId", MEMBER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoteSummary, T> g) {
        return obj -> g.apply((VoteSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoteSummary> {
        /**
         * <p>
         * The vote value, either <code>YES</code> or <code>NO</code>.
         * </p>
         * 
         * @param vote
         *        The vote value, either <code>YES</code> or <code>NO</code>.
         * @see VoteValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoteValue
         */
        Builder vote(String vote);

        /**
         * <p>
         * The vote value, either <code>YES</code> or <code>NO</code>.
         * </p>
         * 
         * @param vote
         *        The vote value, either <code>YES</code> or <code>NO</code>.
         * @see VoteValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoteValue
         */
        Builder vote(VoteValue vote);

        /**
         * <p>
         * The name of the member that cast the vote.
         * </p>
         * 
         * @param memberName
         *        The name of the member that cast the vote.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberName(String memberName);

        /**
         * <p>
         * The unique identifier of the member that cast the vote.
         * </p>
         * 
         * @param memberId
         *        The unique identifier of the member that cast the vote.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);
    }

    static final class BuilderImpl implements Builder {
        private String vote;

        private String memberName;

        private String memberId;

        private BuilderImpl() {
        }

        private BuilderImpl(VoteSummary model) {
            vote(model.vote);
            memberName(model.memberName);
            memberId(model.memberId);
        }

        public final String getVote() {
            return vote;
        }

        public final void setVote(String vote) {
            this.vote = vote;
        }

        @Override
        public final Builder vote(String vote) {
            this.vote = vote;
            return this;
        }

        @Override
        public final Builder vote(VoteValue vote) {
            this.vote(vote == null ? null : vote.toString());
            return this;
        }

        public final String getMemberName() {
            return memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getMemberId() {
            return memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        @Override
        public VoteSummary build() {
            return new VoteSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
