/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessorsResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<ListAccessorsResponse.Builder, ListAccessorsResponse> {
    private static final SdkField<List<AccessorSummary>> ACCESSORS_FIELD = SdkField
            .<List<AccessorSummary>> builder(MarshallingType.LIST)
            .memberName("Accessors")
            .getter(getter(ListAccessorsResponse::accessors))
            .setter(setter(Builder::accessors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accessors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccessorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSORS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccessorSummary> accessors;

    private final String nextToken;

    private ListAccessorsResponse(BuilderImpl builder) {
        super(builder);
        this.accessors = builder.accessors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accessors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccessors() {
        return accessors != null && !(accessors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of AccessorSummary objects that contain configuration properties for each accessor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessors} method.
     * </p>
     * 
     * @return An array of AccessorSummary objects that contain configuration properties for each accessor.
     */
    public final List<AccessorSummary> accessors() {
        return accessors;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessors() ? accessors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessorsResponse)) {
            return false;
        }
        ListAccessorsResponse other = (ListAccessorsResponse) obj;
        return hasAccessors() == other.hasAccessors() && Objects.equals(accessors(), other.accessors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessorsResponse").add("Accessors", hasAccessors() ? accessors() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accessors":
            return Optional.ofNullable(clazz.cast(accessors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accessors", ACCESSORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessorsResponse, T> g) {
        return obj -> g.apply((ListAccessorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessorsResponse> {
        /**
         * <p>
         * An array of AccessorSummary objects that contain configuration properties for each accessor.
         * </p>
         * 
         * @param accessors
         *        An array of AccessorSummary objects that contain configuration properties for each accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessors(Collection<AccessorSummary> accessors);

        /**
         * <p>
         * An array of AccessorSummary objects that contain configuration properties for each accessor.
         * </p>
         * 
         * @param accessors
         *        An array of AccessorSummary objects that contain configuration properties for each accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessors(AccessorSummary... accessors);

        /**
         * <p>
         * An array of AccessorSummary objects that contain configuration properties for each accessor.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.managedblockchain.model.AccessorSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.managedblockchain.model.AccessorSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.managedblockchain.model.AccessorSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #accessors(List<AccessorSummary>)}.
         * 
         * @param accessors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.managedblockchain.model.AccessorSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessors(java.util.Collection<AccessorSummary>)
         */
        Builder accessors(Consumer<AccessorSummary.Builder>... accessors);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private List<AccessorSummary> accessors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessorsResponse model) {
            super(model);
            accessors(model.accessors);
            nextToken(model.nextToken);
        }

        public final List<AccessorSummary.Builder> getAccessors() {
            List<AccessorSummary.Builder> result = AccessorSummaryListCopier.copyToBuilder(this.accessors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessors(Collection<AccessorSummary.BuilderImpl> accessors) {
            this.accessors = AccessorSummaryListCopier.copyFromBuilder(accessors);
        }

        @Override
        public final Builder accessors(Collection<AccessorSummary> accessors) {
            this.accessors = AccessorSummaryListCopier.copy(accessors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessors(AccessorSummary... accessors) {
            accessors(Arrays.asList(accessors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessors(Consumer<AccessorSummary.Builder>... accessors) {
            accessors(Stream.of(accessors).map(c -> AccessorSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessorsResponse build() {
            return new ListAccessorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
