/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessorResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<GetAccessorResponse.Builder, GetAccessorResponse> {
    private static final SdkField<Accessor> ACCESSOR_FIELD = SdkField.<Accessor> builder(MarshallingType.SDK_POJO)
            .memberName("Accessor").getter(getter(GetAccessorResponse::accessor)).setter(setter(Builder::accessor))
            .constructor(Accessor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accessor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Accessor accessor;

    private GetAccessorResponse(BuilderImpl builder) {
        super(builder);
        this.accessor = builder.accessor;
    }

    /**
     * <p>
     * The properties of the accessor.
     * </p>
     * 
     * @return The properties of the accessor.
     */
    public final Accessor accessor() {
        return accessor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessorResponse)) {
            return false;
        }
        GetAccessorResponse other = (GetAccessorResponse) obj;
        return Objects.equals(accessor(), other.accessor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessorResponse").add("Accessor", accessor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accessor":
            return Optional.ofNullable(clazz.cast(accessor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accessor", ACCESSOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessorResponse, T> g) {
        return obj -> g.apply((GetAccessorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccessorResponse> {
        /**
         * <p>
         * The properties of the accessor.
         * </p>
         * 
         * @param accessor
         *        The properties of the accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessor(Accessor accessor);

        /**
         * <p>
         * The properties of the accessor.
         * </p>
         * This is a convenience method that creates an instance of the {@link Accessor.Builder} avoiding the need to
         * create one manually via {@link Accessor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Accessor.Builder#build()} is called immediately and its result is
         * passed to {@link #accessor(Accessor)}.
         * 
         * @param accessor
         *        a consumer that will call methods on {@link Accessor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessor(Accessor)
         */
        default Builder accessor(Consumer<Accessor.Builder> accessor) {
            return accessor(Accessor.builder().applyMutation(accessor).build());
        }
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private Accessor accessor;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessorResponse model) {
            super(model);
            accessor(model.accessor);
        }

        public final Accessor.Builder getAccessor() {
            return accessor != null ? accessor.toBuilder() : null;
        }

        public final void setAccessor(Accessor.BuilderImpl accessor) {
            this.accessor = accessor != null ? accessor.build() : null;
        }

        @Override
        public final Builder accessor(Accessor accessor) {
            this.accessor = accessor;
            return this;
        }

        @Override
        public GetAccessorResponse build() {
            return new GetAccessorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
